/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.UV;
import org.joml.Matrix4f;

public class GuiHelper {
    public static final ResourceLocation GUI_CONTROLS = SophisticatedCore.getRL("textures/gui/gui_controls.png");
    private static final int GUI_CONTROLS_TEXTURE_WIDTH = 256;
    private static final int GUI_CONTROLS_TEXTURE_HEIGHT = 256;
    public static final TextureBlitData BAR_BACKGROUND_BOTTOM = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 66), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_MIDDLE = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 48), Dimension.SQUARE_18);
    public static final TextureBlitData BAR_BACKGROUND_TOP = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 30), Dimension.SQUARE_18);
    public static final ResourceLocation ICONS = SophisticatedCore.getRL("textures/gui/icons.png");
    public static final TextureBlitData CRAFTING_RESULT_SLOT = new TextureBlitData(GUI_CONTROLS, new UV(71, 216), new Dimension(26, 26));
    public static final TextureBlitData DEFAULT_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(47, 0), Dimension.SQUARE_18);
    public static final TextureBlitData DEFAULT_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, new UV(29, 0), Dimension.SQUARE_18);
    public static final TextureBlitData SMALL_BUTTON_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(29, 18), Dimension.SQUARE_12);
    public static final TextureBlitData SMALL_BUTTON_HOVERED_BACKGROUND = new TextureBlitData(GUI_CONTROLS, Dimension.SQUARE_256, new UV(41, 18), Dimension.SQUARE_12);
    public static final ResourceLocation SLOTS_BACKGROUND = SophisticatedCore.getRL("textures/gui/slots_background.png");
    private static final Map<Integer, TextureBlitData> SLOTS_BACKGROUNDS = new HashMap<Integer, TextureBlitData>();

    private GuiHelper() {
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, false);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotWidth, int slotHeight) {
        int currentY = y;
        for (int remainingSlotHeight = slotHeight; remainingSlotHeight > 0; remainingSlotHeight -= Math.min(slotHeight, 12)) {
            int finalRemainingSlotHeight = remainingSlotHeight;
            int key = GuiHelper.getSlotsBackgroundKey(slotWidth, remainingSlotHeight);
            GuiHelper.blit(guiGraphics, x, currentY, SLOTS_BACKGROUNDS.computeIfAbsent(key, k -> new TextureBlitData(SLOTS_BACKGROUND, Dimension.SQUARE_256, new UV(0, 0), new Dimension(slotWidth * 18, finalRemainingSlotHeight * 18))));
            currentY += 216;
        }
    }

    private static int getSlotsBackgroundKey(int slotWidth, int slotHeight) {
        return slotWidth * 31 + slotHeight;
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay) {
        GuiHelper.renderItemInGUI(guiGraphics, minecraft, stack, xPosition, yPosition, renderOverlay, null);
    }

    public static void renderItemInGUI(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int xPosition, int yPosition, boolean renderOverlay, @Nullable String countText) {
        RenderSystem.enableDepthTest();
        guiGraphics.renderItem(stack, xPosition, yPosition);
        if (renderOverlay) {
            guiGraphics.renderItemDecorations(minecraft.font, stack, xPosition, yPosition, countText);
        }
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData) {
        guiGraphics.blit(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), texData.getWidth(), texData.getHeight(), texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void blit(GuiGraphics guiGraphics, int x, int y, TextureBlitData texData, int width, int height) {
        int halfWidth = width / 2;
        int secondHalfWidth = width - halfWidth;
        int halfHeight = height / 2;
        int secondHalfHeight = height - halfHeight;
        guiGraphics.blit(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset(), (float)texData.getU(), (float)texData.getV(), halfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset(), (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV(), secondHalfWidth, halfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(texData.getTextureName(), x + texData.getXOffset(), y + texData.getYOffset() + halfHeight, (float)texData.getU(), (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, halfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
        guiGraphics.blit(texData.getTextureName(), x + texData.getXOffset() + halfWidth, y + texData.getYOffset() + halfHeight, (float)texData.getU() + (float)texData.getWidth() - (float)secondHalfWidth, (float)texData.getV() + (float)texData.getHeight() - (float)secondHalfHeight, secondHalfWidth, secondHalfHeight, texData.getTextureWidth(), texData.getTextureHeight());
    }

    public static void coloredBlit(Matrix4f matrix, int x, int y, TextureBlitData texData, int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        int xMin = x + texData.getXOffset();
        int yMin = y + texData.getYOffset();
        int xMax = xMin + texData.getWidth();
        int yMax = yMin + texData.getHeight();
        float minU = (float)texData.getU() / (float)texData.getTextureWidth();
        float maxU = minU + (float)texData.getWidth() / (float)texData.getTextureWidth();
        float minV = (float)texData.getV() / (float)texData.getTextureHeight();
        float maxV = minV + (float)texData.getHeight() / (float)texData.getTextureWidth();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix, (float)xMin, (float)yMax, 0.0f).setUv(minU, maxV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix, (float)xMax, (float)yMax, 0.0f).setUv(maxU, maxV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix, (float)xMax, (float)yMin, 0.0f).setUv(maxU, minV).setColor(red, green, blue, alpha);
        bufferbuilder.addVertex(matrix, (float)xMin, (float)yMin, 0.0f).setUv(minU, minV).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void renderTooltipBackground(Matrix4f matrix4f, int tooltipWidth, int leftX, int topY, int tooltipHeight, int backgroundColor, int borderColorStart, int borderColorEnd) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 4, leftX + tooltipWidth + 3, topY - 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 4, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 4, topY - 3, leftX - 3, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 3, topY - 3, leftX + tooltipWidth + 4, topY + tooltipHeight + 3, backgroundColor, backgroundColor);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3 + 1, leftX - 3 + 1, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX + tooltipWidth + 2, topY - 3 + 1, leftX + tooltipWidth + 3, topY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY - 3, leftX + tooltipWidth + 3, topY - 3 + 1, borderColorStart, borderColorStart);
        GuiHelper.fillGradient(matrix4f, bufferbuilder, leftX - 3, topY + tooltipHeight + 2, leftX + tooltipWidth + 3, topY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void writeTooltipLines(GuiGraphics guiGraphics, List<FormattedCharSequence> textLines, Font font, float leftX, int topY, Matrix4f matrix4f, MultiBufferSource.BufferSource renderTypeBuffer, int color) {
        for (int i = 0; i < textLines.size(); ++i) {
            FormattedCharSequence line = textLines.get(i);
            if (line != null) {
                guiGraphics.drawString(font, line, leftX, (float)topY, color, true);
            }
            if (i == 0) {
                topY += 2;
            }
            topY += 10;
        }
    }

    private static void fillGradient(Matrix4f matrix, BufferBuilder builder, int x1, int y1, int x2, int y2, int colorA, int colorB) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.addVertex(matrix, (float)x2, (float)y1, 400.0f).setColor(f1, f2, f3, f);
        builder.addVertex(matrix, (float)x1, (float)y1, 400.0f).setColor(f1, f2, f3, f);
        builder.addVertex(matrix, (float)x1, (float)y2, 400.0f).setColor(f5, f6, f7, f4);
        builder.addVertex(matrix, (float)x2, (float)y2, 400.0f).setColor(f5, f6, f7, f4);
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, Component ... tooltip) {
        return GuiHelper.getButtonStateData(uv, dimension, offset, Arrays.asList(tooltip));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension) {
        return GuiHelper.getButtonStateData(uv, tooltip, dimension, new Position(0, 0));
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, String tooltip, Dimension dimension, Position offset) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), new Component[]{Component.translatable((String)tooltip)});
    }

    public static ToggleButton.StateData getButtonStateData(UV uv, Dimension dimension, Position offset, List<Component> tooltip) {
        return new ToggleButton.StateData(new TextureBlitData(ICONS, offset, Dimension.SQUARE_256, uv, dimension), tooltip);
    }

    public static void renderSlotsBackground(GuiGraphics guiGraphics, int x, int y, int slotsInRow, int fullSlotRows, int extraRowSlots) {
        GuiHelper.renderSlotsBackground(guiGraphics, x, y, slotsInRow, fullSlotRows);
        if (extraRowSlots > 0) {
            GuiHelper.renderSlotsBackground(guiGraphics, x, y + fullSlotRows * 18, extraRowSlots, 1);
        }
    }

    public static void renderTiledFluidTextureAtlas(GuiGraphics guiGraphics, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        int spriteHeight = sprite.contents().height();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v1 = sprite.getV((float)renderHeight / (float)spriteHeight);
            Matrix4f matrix = guiGraphics.pose().last().pose();
            float u1 = sprite.getU1();
            builder.addVertex(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).setUv(u0, v1).setColor(red, green, blue, 1.0f);
            builder.addVertex(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).setUv(u1, v1).setColor(red, green, blue, 1.0f);
            builder.addVertex(matrix, (float)x + 16.0f, (float)startY, 100.0f).setUv(u1, v0).setColor(red, green, blue, 1.0f);
            builder.addVertex(matrix, (float)x, (float)startY, 100.0f).setUv(u0, v0).setColor(red, green, blue, 1.0f);
            startY += renderHeight;
        } while (height > 0);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static void renderControlBackground(GuiGraphics guiGraphics, int x, int y, int renderWidth, int renderHeight) {
        int u = 29;
        int v = 146;
        int textureBgWidth = 66;
        int textureBgHeight = 56;
        int halfWidth = renderWidth / 2;
        int halfHeight = renderHeight / 2;
        guiGraphics.blit(GUI_CONTROLS, x, y, (float)u, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(GUI_CONTROLS, x, y + halfHeight, (float)u, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(GUI_CONTROLS, x + halfWidth, y, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v, halfWidth, halfHeight, 256, 256);
        guiGraphics.blit(GUI_CONTROLS, x + halfWidth, y + halfHeight, (float)u + (float)textureBgWidth - (float)halfWidth, (float)v + (float)textureBgHeight - (float)halfHeight, halfWidth, halfHeight, 256, 256);
    }

    public static void tryRenderGuiItem(GuiGraphics guiGraphics, ItemRenderer itemRenderer, @Nullable LivingEntity livingEntity, ItemStack stack, int x, int y, int rotation) {
        if (!stack.isEmpty()) {
            BakedModel bakedmodel = itemRenderer.getModel(stack, null, livingEntity, 0);
            try {
                GuiHelper.renderGuiItem(guiGraphics, itemRenderer, stack, x, y, bakedmodel, rotation);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Item being rendered");
                crashreportcategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                crashreportcategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                crashreportcategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                throw new ReportedException(crashreport);
            }
        }
    }

    private static void renderGuiItem(GuiGraphics guiGraphics, ItemRenderer itemRenderer, ItemStack stack, int x, int y, BakedModel bakedModel, int rotation) {
        boolean flag;
        PoseStack posestack = guiGraphics.pose();
        posestack.pushPose();
        posestack.translate((float)x + 8.0f, (float)y + 8.0f, 150.0f);
        if (rotation != 0) {
            posestack.mulPose(Axis.ZP.rotationDegrees((float)rotation));
        }
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !bakedModel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, posestack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        RenderSystem.disableDepthTest();
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderTooltip(Screen screen, GuiGraphics guiGraphics, List<Component> components, int x, int y) {
        List<ClientTooltipComponent> list = GuiHelper.gatherTooltipComponents(components, x, screen.width, screen.height, screen.font);
        guiGraphics.renderTooltipInternal(screen.font, list, x, y, DefaultTooltipPositioner.INSTANCE);
    }

    public static List<ClientTooltipComponent> gatherTooltipComponents(List<? extends FormattedText> textElements, int mouseX, int screenWidth, int screenHeight, Font fallbackFont) {
        Font font = ClientHooks.getTooltipFont((ItemStack)ItemStack.EMPTY, (Font)fallbackFont);
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        RenderTooltipEvent.GatherComponents event = new RenderTooltipEvent.GatherComponents(ItemStack.EMPTY, screenWidth, screenHeight, elements, -1);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return List.of();
        }
        int tooltipX = mouseX + 12;
        int tooltipTextWidth = event.getTooltipElements().stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((Font)font).width(arg_0), component -> 0)).max().orElse(0);
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        if (event.getMaxWidth() > 0 && tooltipTextWidth > event.getMaxWidth()) {
            tooltipTextWidth = event.getMaxWidth();
        }
        int tooltipTextWidthF = tooltipTextWidth;
        return event.getTooltipElements().stream().flatMap(either -> (Stream)either.map(text -> font.split(text, tooltipTextWidthF).stream().map(ClientTooltipComponent::create), component -> Stream.of(ClientTooltipComponent.create((TooltipComponent)component)))).toList();
    }

    public static Optional<Rect2i> getPositiveRectangle(int x, int y, int width, int height) {
        if (x + width <= 0 || y + height <= 0) {
            return Optional.empty();
        }
        int positiveX = Math.max(0, x);
        int positiveY = Math.max(0, y);
        int positiveWidth = width + Math.min(0, x);
        int positiveHeight = height + Math.min(0, y);
        return Optional.of(new Rect2i(positiveX, positiveY, positiveWidth, positiveHeight));
    }
}

