/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.scheduler;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="mekanism_turrets", value={Dist.DEDICATED_SERVER})
public final class Scheduler {
    static final ConcurrentMap<Integer, List<Runnable>> SERVER_SCHEDULE = new ConcurrentHashMap<Integer, List<Runnable>>();

    private Scheduler() {
    }

    public static void schedule(Runnable task, int delay) {
        SERVER_SCHEDULE.compute(ServerLifecycleHooks.getCurrentServer().getTickCount() + delay, (integer, runnables) -> {
            if (runnables == null) {
                runnables = new ObjectArrayList();
            }
            runnables.add(task);
            return runnables;
        });
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Pre event) {
        int ticks = ServerLifecycleHooks.getCurrentServer().getTickCount();
        List tasks = (List)SERVER_SCHEDULE.get(ticks);
        if (tasks != null) {
            tasks.forEach(Runnable::run);
            SERVER_SCHEDULE.remove(ticks);
        }
    }
}

