/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.entity;

import com.github.x3r.mekanism_turrets.common.block.LaserTurretBlock;
import com.github.x3r.mekanism_turrets.common.registry.DamageTypeRegistry;
import com.github.x3r.mekanism_turrets.common.registry.EntityRegistry;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LaserEntity
extends Projectile {
    private int lifeTime = 0;
    private double damage = 1.0;

    public LaserEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noPhysics = true;
    }

    public LaserEntity(Level pLevel, Vec3 pos, double damage) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.LASER.get()), pLevel);
        this.setPos(pos);
        this.damage = damage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            HitResult hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            if (hitResult.getType().equals((Object)HitResult.Type.BLOCK)) {
                this.onHitBlock((BlockHitResult)hitResult);
            }
            this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5)).forEach(entity -> entity.hurt(new DamageTypeRegistry(this.level().registryAccess()).laser(), (float)this.damage));
            ++this.lifeTime;
            if (this.lifeTime > 200) {
                this.discard();
            }
        }
        this.setPos(this.position().add(this.getDeltaMovement()));
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        if (!this.level().isClientSide()) {
            pResult.getEntity().hurt(new DamageTypeRegistry(this.level().registryAccess()).laser(), (float)this.damage);
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        BlockState state = this.level().getBlockState(pResult.getBlockPos());
        if (!(state.getBlock() instanceof LaserTurretBlock) && state.isCollisionShapeFullBlock((BlockGetter)this.level(), pResult.getBlockPos())) {
            this.discard();
        }
    }
}

