/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block_entity;

import java.util.function.Supplier;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;

public enum LaserTurretTier implements ITier
{
    BASIC(BaseTier.BASIC, 80, 1.0, 10000, 15.0),
    ADVANCED(BaseTier.ADVANCED, 65, 2.0, 40000, 25.0),
    ELITE(BaseTier.ELITE, 50, 3.0, 90000, 35.0),
    ULTIMATE(BaseTier.ULTIMATE, 35, 4.0, 160000, 45.0);

    private final BaseTier baseTier;
    private final int cooldown;
    private final double damage;
    private final int energyCapacity;
    private final double range;
    private Integer cooldownReference;
    private Double damageReference;
    private Integer energyCapacityReference;
    private Double rangeReference;

    private LaserTurretTier(BaseTier baseTier, int cooldown, double damage, int energyCapacity, double range) {
        this.baseTier = baseTier;
        this.cooldown = cooldown;
        this.damage = damage;
        this.energyCapacity = energyCapacity;
        this.range = range;
    }

    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public int getCooldown() {
        return this.cooldownReference == null ? this.getBaseCooldown() : this.cooldownReference.intValue();
    }

    private int getBaseCooldown() {
        return this.cooldown;
    }

    public double getDamage() {
        return this.damageReference == null ? this.getBaseDamage() : this.damageReference.doubleValue();
    }

    private double getBaseDamage() {
        return this.damage;
    }

    public int getEnergyCapacity() {
        return this.energyCapacityReference == null ? this.getBaseEnergyCapacity() : this.energyCapacityReference.intValue();
    }

    private int getBaseEnergyCapacity() {
        return this.energyCapacity;
    }

    public double getRange() {
        return this.rangeReference == null ? this.getBaseRange() : this.rangeReference.doubleValue();
    }

    private double getBaseRange() {
        return this.range;
    }

    public void setConfigReference(Supplier<Integer> cooldownReference, Supplier<Double> damageReference, Supplier<Integer> energyCapacityReference, Supplier<Double> rangeReference) {
        this.cooldownReference = cooldownReference.get();
        this.damageReference = damageReference.get();
        this.energyCapacityReference = energyCapacityReference.get();
        this.rangeReference = rangeReference.get();
    }
}

