/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.common.block_entity;

import com.github.x3r.mekanism_turrets.MekanismTurretsConfig;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretUpgradeData;
import com.github.x3r.mekanism_turrets.common.entity.LaserEntity;
import com.github.x3r.mekanism_turrets.common.registry.SoundRegistry;
import com.github.x3r.mekanism_turrets.common.scheduler.Scheduler;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserTurretBlockEntity
extends TileEntityMekanism
implements GeoBlockEntity {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    public static SerializableDataTicket<Boolean> HAS_TARGET;
    public static SerializableDataTicket<Double> TARGET_POS_X;
    public static SerializableDataTicket<Double> TARGET_POS_Y;
    public static SerializableDataTicket<Double> TARGET_POS_Z;
    private static final RawAnimation SHOOT_ANIMATION;
    private final AABB targetBox = AABB.ofSize((Vec3)this.getBlockPos().getCenter(), (double)(this.getTier().getRange() * 2.0), (double)(this.getTier().getRange() * 2.0), (double)(this.getTier().getRange() * 2.0));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LaserTurretTier tier;
    private MachineEnergyContainer<LaserTurretBlockEntity> energyContainer;
    private boolean targetsHostile = true;
    private boolean targetsPassive = false;
    private boolean targetsPlayers = false;
    private boolean targetsTrusted = true;
    @Nullable
    private LivingEntity target;
    public float xRot0 = 0.0f;
    public float yRot0 = 0.0f;
    private int coolDown = 0;
    private int idleTicks = 0;

    public LaserTurretBlockEntity(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(() -> ((LaserTurretBlockEntity)this).getDirection());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    public MachineEnergyContainer<LaserTurretBlockEntity> getEnergyContainer() {
        return this.energyContainer;
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((LaserTurretBlockEntity)this).getDirection());
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((LaserTurretBlockEntity)this).getLevel(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    public LaserTurretTier getTier() {
        return this.tier;
    }

    public boolean targetsHostile() {
        return this.targetsHostile;
    }

    public void setTargetsHostile(boolean targetsHostile) {
        this.targetsHostile = targetsHostile;
    }

    public boolean targetsPassive() {
        return this.targetsPassive;
    }

    public void setTargetsPassive(boolean targetsPassive) {
        this.targetsPassive = targetsPassive;
    }

    public boolean targetsPlayers() {
        return this.targetsPlayers;
    }

    public void setTargetsPlayers(boolean targetsPlayers) {
        this.targetsPlayers = targetsPlayers;
    }

    public boolean targetsTrusted() {
        return this.targetsTrusted;
    }

    public void setTargetsTrusted(boolean targetsTrusted) {
        this.targetsTrusted = targetsTrusted;
    }

    protected boolean onUpdateServer() {
        this.energySlot.fillContainerOrConvert();
        this.tryInvalidateTarget();
        this.tryFindTarget();
        this.energyContainer.setEnergyPerTick((long)this.laserShotEnergy());
        if (this.target != null) {
            Vec3 targetPos = LaserTurretBlockEntity.getShootLocation(this.target);
            this.setAnimData(TARGET_POS_X, targetPos.x);
            this.setAnimData(TARGET_POS_Y, targetPos.y);
            this.setAnimData(TARGET_POS_Z, targetPos.z);
            this.setAnimData(HAS_TARGET, this.target != null);
            if (this.coolDown == 0) {
                this.coolDown = Math.max(0, this.tier.getCooldown() - 2 * this.upgradeComponent.getUpgrades(Upgrade.SPEED));
                if (this.energyContainer.getEnergy() >= (long)this.laserShotEnergy()) {
                    this.shootLaser();
                    if (this.tier.equals((Object)LaserTurretTier.ULTIMATE)) {
                        Scheduler.schedule(this::shootLaser, 10);
                    }
                }
            } else {
                --this.coolDown;
            }
        }
        return super.onUpdateServer();
    }

    private static Vec3 getShootLocation(LivingEntity entity) {
        Vec3 targetPos = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        double laserSpeed = 2.25;
        for (int i = 1; i < 21; ++i) {
            Vec3 deltaMovement = entity.getDeltaMovement().multiply(0.95, 0.0, 0.95);
            Vec3 nextPos = targetPos.add(deltaMovement.scale((double)(i - 1)));
            if (!(nextPos.length() <= laserSpeed * (double)i) && i != 20) continue;
            return new Vec3(nextPos.x, nextPos.y + (double)entity.getBbHeight() * 0.75, nextPos.z);
        }
        return targetPos;
    }

    private void shootLaser() {
        if (this.target != null) {
            int mufflerCount = this.getComponent().getUpgrades(Upgrade.MUFFLING);
            float volume = 1.0f - (float)mufflerCount / (float)Upgrade.MUFFLING.getMax();
            this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundRegistry.TURRET_SHOOT.get(), SoundSource.BLOCKS, volume, 1.0f);
            this.triggerAnim("controller", "shoot");
            Vec3 center = this.getBlockPos().getCenter();
            Vec3 targetPos = LaserTurretBlockEntity.getShootLocation(this.target);
            LaserEntity laser = new LaserEntity(this.level, center.add(0.0, -0.15, 0.0), this.tier.getDamage());
            laser.setDeltaMovement(center.vectorTo(targetPos).normalize().scale(2.25));
            this.level.addFreshEntity((Entity)laser);
            this.energyContainer.extract((long)this.laserShotEnergy(), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    private int laserShotEnergy() {
        return 1000 * (this.tier.ordinal() + 1) * Mth.square((int)(this.upgradeComponent.getUpgrades(Upgrade.SPEED) + 1));
    }

    public void tryInvalidateTarget() {
        if (!this.isValidTarget(this.target)) {
            this.setAnimData(HAS_TARGET, false);
            this.target = null;
        }
    }

    private void tryFindTarget() {
        if (this.idleTicks-- > 0) {
            return;
        }
        if (this.target == null && (this.level.getGameTime() + (long)((Object)((Object)this)).hashCode()) % 3L == 0L) {
            Optional optional = this.level.getEntitiesOfClass(LivingEntity.class, this.targetBox, this::isValidTarget).stream().min((o1, o2) -> Double.compare(o1.distanceToSqr(this.getBlockPos().getCenter()), o2.distanceToSqr(this.getBlockPos().getCenter())));
            if (optional.isPresent()) {
                this.target = (LivingEntity)optional.get();
                this.setAnimData(HAS_TARGET, true);
            } else {
                this.idleTicks = 80;
            }
        }
    }

    private boolean isValidTarget(LivingEntity e) {
        if (e == null) {
            return false;
        }
        if (!e.canBeSeenAsEnemy()) {
            return false;
        }
        if (e.distanceToSqr(this.getBlockPos().getCenter()) > this.getTier().getRange() * this.getTier().getRange()) {
            return false;
        }
        if (MekanismTurretsConfig.blacklistedEntities == null) {
            return false;
        }
        if (((List)MekanismTurretsConfig.blacklistedEntities.get()).stream().map(s -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)s))).anyMatch(entityType -> e.getType().equals(entityType))) {
            return false;
        }
        if (!this.turretFlagsAllowTargeting(e)) {
            return false;
        }
        return this.canSeeTarget(e);
    }

    private boolean turretFlagsAllowTargeting(LivingEntity e) {
        Player player;
        MobCategory category = e.getType().getCategory();
        if (this.targetsHostile && !category.isFriendly()) {
            return true;
        }
        if (this.targetsPassive && category.isFriendly() && !category.equals((Object)MobCategory.MISC)) {
            return true;
        }
        UUID owner = this.getOwnerUUID();
        if (this.targetsPlayers && e instanceof Player && !(player = (Player)e).getUUID().equals(owner)) {
            if (this.targetsTrusted) {
                return true;
            }
            SecurityFrequency frequency = this.getSecurity().getFrequency();
            if (frequency == null) {
                return true;
            }
            if (!frequency.isTrusted(player.getUUID())) {
                return true;
            }
        }
        return false;
    }

    private boolean canSeeTarget(LivingEntity e) {
        Vec3 center = this.getBlockPos().getCenter();
        Vec3 targetPos = e.position().add(0.0, (double)e.getBbHeight() * 0.75, 0.0);
        Vec3 lookVec = center.vectorTo(targetPos).normalize().scale(0.75);
        ClipContext ctx = new ClipContext(center.add(lookVec), targetPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty());
        return this.level.clip(ctx).getType().equals((Object)HitResult.Type.MISS);
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData data) {
        if (data instanceof LaserTurretUpgradeData) {
            LaserTurretUpgradeData upgradeData = (LaserTurretUpgradeData)data;
            this.targetsHostile = upgradeData.targetsHostile();
            this.targetsPassive = upgradeData.targetsPassive();
            this.targetsPlayers = upgradeData.targetsPlayers();
            this.targetsTrusted = upgradeData.targetsTrusted();
            for (ITileComponent component : this.getComponents()) {
                component.read(upgradeData.components(), provider);
            }
        } else {
            super.parseUpgradeData(provider, data);
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new LaserTurretUpgradeData(this.targetsHostile, this.targetsPassive, this.targetsPlayers, this.targetsTrusted, this.getComponents(), provider);
    }

    public void onLoad() {
        super.onLoad();
        this.markUpdated();
    }

    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("targetsHostile", this.targetsHostile);
        tag.putBoolean("targetsPassive", this.targetsPassive);
        tag.putBoolean("targetsPlayers", this.targetsPlayers);
        tag.putBoolean("targetsTrusted", this.targetsTrusted);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsHostile", value -> {
            this.targetsHostile = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPassive", value -> {
            this.targetsPassive = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPlayers", value -> {
            this.targetsPlayers = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsTrusted", value -> {
            this.targetsTrusted = value;
        });
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getReducedUpdateTag(provider);
        tag.putBoolean("targetsHostile", this.targetsHostile);
        tag.putBoolean("targetsPassive", this.targetsPassive);
        tag.putBoolean("targetsPlayers", this.targetsPlayers);
        tag.putBoolean("targetsTrusted", this.targetsTrusted);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsHostile", value -> {
            this.targetsHostile = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPassive", value -> {
            this.targetsPassive = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsPlayers", value -> {
            this.targetsPlayers = value;
        });
        NBTUtils.setBooleanIfPresent((CompoundTag)tag, (String)"targetsTrusted", value -> {
            this.targetsTrusted = value;
        });
    }

    public void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        if (!this.level.isClientSide()) {
            this.sendUpdatePacket();
        }
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = (LaserTurretTier)Attribute.getTier((Block)this.getBlockType(), LaserTurretTier.class);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE).triggerableAnim("shoot", SHOOT_ANIMATION));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static {
        SHOOT_ANIMATION = RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE);
    }
}

