/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.client.gui;

import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.packet.ModifyTurretTargetPayload;
import java.util.List;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.ToggleButton;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class LaserTurretScreen
extends GuiMekanismTile<LaserTurretBlockEntity, MekanismTileContainer<LaserTurretBlockEntity>> {
    private static final ResourceLocation TARGET_HOSTILE_OFF = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_hostile_off.png");
    private static final ResourceLocation TARGET_HOSTILE_ON = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_hostile_on.png");
    private static final ResourceLocation TARGET_PASSIVE_OFF = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_passive_off.png");
    private static final ResourceLocation TARGET_PASSIVE_ON = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_passive_on.png");
    private static final ResourceLocation TARGET_PLAYER_OFF = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_players_off.png");
    private static final ResourceLocation TARGET_PLAYER_ON = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_players_on.png");
    private static final ResourceLocation TARGET_TRUSTED_OFF = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_trusted_off.png");
    private static final ResourceLocation TARGET_TRUSTED_ON = ResourceLocation.fromNamespaceAndPath((String)"mekanism_turrets", (String)"textures/gui/target_trusted_on.png");

    public LaserTurretScreen(MekanismTileContainer<LaserTurretBlockEntity> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        ((GuiVerticalPowerBar)this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, ((LaserTurretBlockEntity)this.tile).getEnergyContainer(), 164, 15))).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MachineEnergyContainer<LaserTurretBlockEntity> energyContainer = ((LaserTurretBlockEntity)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick() > energyContainer.getEnergy();
        });
        long energyPerTick = ((LaserTurretBlockEntity)this.tile).getEnergyContainer().getEnergyPerTick();
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> List.of(Component.translatable((String)"gui.turret.energy_per_shot").append(EnergyDisplay.of((long)energyPerTick).getTextComponent()), MekanismLang.NEEDED.translate(new Object[]{EnergyDisplay.of((long)(energyPerTick - ((LaserTurretBlockEntity)this.tile).getEnergyContainer().getEnergy()))}))));
        int i = 25;
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40, 33, 20, 20, TARGET_HOSTILE_OFF, TARGET_HOSTILE_ON, ((LaserTurretBlockEntity)this.tile)::targetsHostile, (element, mouseX, mouseY) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ModifyTurretTargetPayload(((LaserTurretBlockEntity)this.tile).getBlockPos(), 0, !((LaserTurretBlockEntity)this.tile).targetsHostile()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }, (Component)Component.translatable((String)"gui.turret.stop_targeting_hostile"), (Component)Component.translatable((String)"gui.turret.start_targeting_hostile")));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + i, 33, 20, 20, TARGET_PASSIVE_OFF, TARGET_PASSIVE_ON, ((LaserTurretBlockEntity)this.tile)::targetsPassive, (element, mouseX, mouseY) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ModifyTurretTargetPayload(((LaserTurretBlockEntity)this.tile).getBlockPos(), 1, !((LaserTurretBlockEntity)this.tile).targetsPassive()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }, (Component)Component.translatable((String)"gui.turret.stop_targeting_passive"), (Component)Component.translatable((String)"gui.turret.start_targeting_passive")));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + 2 * i, 33, 20, 20, TARGET_PLAYER_OFF, TARGET_PLAYER_ON, ((LaserTurretBlockEntity)this.tile)::targetsPlayers, (element, mouseX, mouseY) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ModifyTurretTargetPayload(((LaserTurretBlockEntity)this.tile).getBlockPos(), 2, !((LaserTurretBlockEntity)this.tile).targetsPlayers()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }, (Component)Component.translatable((String)"gui.turret.stop_targeting_players"), (Component)Component.translatable((String)"gui.turret.start_targeting_players")));
        this.addRenderableWidget((GuiElement)new ToggleButton((IGuiWrapper)this, 40 + 3 * i, 33, 20, 20, TARGET_TRUSTED_OFF, TARGET_TRUSTED_ON, ((LaserTurretBlockEntity)this.tile)::targetsTrusted, (element, mouseX, mouseY) -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ModifyTurretTargetPayload(((LaserTurretBlockEntity)this.tile).getBlockPos(), 3, !((LaserTurretBlockEntity)this.tile).targetsTrusted()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }, (Component)Component.translatable((String)"gui.turret.stop_targeting_trusted"), (Component)Component.translatable((String)"gui.turret.start_targeting_trusted")){

            public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                if (((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers()) {
                    super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }

            public boolean isValidClickButton(int button) {
                return ((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers() && super.isValidClickButton(button);
            }

            public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
                if (((LaserTurretBlockEntity)LaserTurretScreen.this.tile).targetsPlayers()) {
                    super.renderToolTip(guiGraphics, mouseX, mouseY);
                }
            }
        });
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

