/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MekanismTurretsConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> blacklistedEntities;
    public static final ModConfigSpec.IntValue basicLaserTurretCooldown;
    public static final ModConfigSpec.DoubleValue basicLaserTurretDamage;
    public static final ModConfigSpec.IntValue basicLaserTurretEnergyCapacity;
    public static final ModConfigSpec.DoubleValue basicLaserTurretRange;
    public static final ModConfigSpec.IntValue advancedLaserTurretCooldown;
    public static final ModConfigSpec.DoubleValue advancedLaserTurretDamage;
    public static final ModConfigSpec.IntValue advancedLaserTurretEnergyCapacity;
    public static final ModConfigSpec.DoubleValue advancedLaserTurretRange;
    public static final ModConfigSpec.IntValue eliteLaserTurretCooldown;
    public static final ModConfigSpec.DoubleValue eliteLaserTurretDamage;
    public static final ModConfigSpec.IntValue eliteLaserTurretEnergyCapacity;
    public static final ModConfigSpec.DoubleValue eliteLaserTurretRange;
    public static final ModConfigSpec.IntValue ultimateLaserTurretCooldown;
    public static final ModConfigSpec.DoubleValue ultimateLaserTurretDamage;
    public static final ModConfigSpec.IntValue ultimateLaserTurretEnergyCapacity;
    public static final ModConfigSpec.DoubleValue ultimateLaserTurretRange;

    private static boolean isEntityId(Object o) {
        String string;
        return o instanceof String && BuiltInRegistries.ENTITY_TYPE.containsKey(ResourceLocation.parse((String)(string = (String)o)));
    }

    static {
        BUILDER.push("Mekanism Turrets Config");
        List<String> defaultBlacklistedEntities = List.of(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ENDER_DRAGON).toString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.IRON_GOLEM).toString());
        blacklistedEntities = BUILDER.comment("Entities which will never be targeted by turrets").defineListAllowEmpty("blacklistedEntities", defaultBlacklistedEntities, MekanismTurretsConfig::isEntityId);
        basicLaserTurretCooldown = BUILDER.comment("Cooldown of the Basic Laser Turret").defineInRange("basicLaserTurretCooldown", 80, 0, Integer.MAX_VALUE);
        basicLaserTurretDamage = BUILDER.comment("Damage of the Basic Laser Turret").defineInRange("basicLaserTurretDamage", 1.0, 0.0, 3.4028234663852886E38);
        basicLaserTurretEnergyCapacity = BUILDER.comment("Energy Capacity of the Basic Laser Turret").defineInRange("basicLaserTurretEnergyCapacity", 10000, 0, Integer.MAX_VALUE);
        basicLaserTurretRange = BUILDER.comment("Range of the Basic Laser Turret").defineInRange("basicLaserTurretRange", 15.0, 0.0, 1000.0);
        advancedLaserTurretCooldown = BUILDER.comment("Cooldown of the Advanced Laser Turret").defineInRange("advancedLaserTurretCooldown", 65, 0, Integer.MAX_VALUE);
        advancedLaserTurretDamage = BUILDER.comment("Damage of the Advanced Laser Turret").defineInRange("advancedLaserTurretDamage", 2.0, 0.0, 2.147483647E9);
        advancedLaserTurretEnergyCapacity = BUILDER.comment("Energy Capacity of the Advanced Laser Turret").defineInRange("advancedLaserTurretEnergyCapacity", 40000, 0, Integer.MAX_VALUE);
        advancedLaserTurretRange = BUILDER.comment("Range of the Advanced Laser Turret").defineInRange("advancedLaserTurretRange", 20.0, 0.0, 1000.0);
        eliteLaserTurretCooldown = BUILDER.comment("Cooldown of the Elite Laser Turret").defineInRange("eliteLaserTurretCooldown", 50, 0, Integer.MAX_VALUE);
        eliteLaserTurretDamage = BUILDER.comment("Damage of the Elite Laser Turret").defineInRange("eliteLaserTurretDamage", 3.0, 0.0, 2.147483647E9);
        eliteLaserTurretEnergyCapacity = BUILDER.comment("Energy Capacity of the Elite Laser Turret").defineInRange("eliteLaserTurretEnergyCapacity", 90000, 0, Integer.MAX_VALUE);
        eliteLaserTurretRange = BUILDER.comment("Range of the Elite Laser Turret").defineInRange("eliteLaserTurretRange", 25.0, 0.0, 1000.0);
        ultimateLaserTurretCooldown = BUILDER.comment("Cooldown of the Ultimate Laser Turret").defineInRange("ultimateLaserTurretCooldown", 35, 0, Integer.MAX_VALUE);
        ultimateLaserTurretDamage = BUILDER.comment("Damage of the Ultimate Laser Turret").defineInRange("ultimateLaserTurretDamage", 4.0, 0.0, 2.147483647E9);
        ultimateLaserTurretEnergyCapacity = BUILDER.comment("Energy Capacity of the Ultimate Laser Turret").defineInRange("ultimateLaserTurretEnergyCapacity", 160000, 0, Integer.MAX_VALUE);
        ultimateLaserTurretRange = BUILDER.comment("Range of the Ultimate Laser Turret").defineInRange("ultimateLaserTurretRange", 30.0, 0.0, 1000.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

