/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsDataComponents;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class TileEntityFusionReactorLogicAdapter
extends TileEntityFusionReactorBlock
implements IReactorLogic<FusionReactorLogic>,
IHasMode {
    public FusionReactorLogic logicType = FusionReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityFusionReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            Level world = this.getLevel();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.worldPosition);
                if (side == null) {
                    world.updateNeighborsAt(this.getBlockPos(), this.getBlockType());
                } else if (!EventHooks.onNeighborNotify((Level)world, (BlockPos)this.worldPosition, (BlockState)this.getBlockState(), EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.neighborChanged(this.worldPosition.relative(side), this.getBlockType(), this.worldPosition);
                }
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((FusionReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.worldPosition.relative(side)) && this.checkMode() ? 15 : 0;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            return switch (this.logicType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (multiblock.fuelTank.isEmpty()) {
                        int injectionPortion = multiblock.getInjectionRate() / 2;
                        if (injectionPortion == 0 || multiblock.deuteriumTank.getStored() < (long)injectionPortion || multiblock.tritiumTank.getStored() < (long)injectionPortion) {
                            yield true;
                        }
                        yield false;
                    }
                    yield false;
                }
                case 0 -> false;
            };
        }
        return false;
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.readSustainedData(provider, nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logic_type", FusionReactorLogic.BY_ID, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbt.getBoolean("active_cooled");
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.writeSustainedData(provider, nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logic_type", (Enum)this.logicType);
        nbtTags.putBoolean("active_cooled", this.activeCooled);
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(GeneratorsDataComponents.FUSION_LOGIC_TYPE, (Object)this.logicType);
        builder.set(GeneratorsDataComponents.ACTIVE_COOLED, (Object)this.activeCooled);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.logicType = (FusionReactorLogic)input.getOrDefault(GeneratorsDataComponents.FUSION_LOGIC_TYPE, (Object)this.logicType);
        this.activeCooled = (Boolean)input.getOrDefault(GeneratorsDataComponents.ACTIVE_COOLED, (Object)this.activeCooled);
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markForSave();
    }

    public void previousMode() {
        this.nextMode();
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FusionReactorLogic getMode() {
        return this.logicType;
    }

    public FusionReactorLogic[] getModes() {
        return FusionReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FusionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FusionReactorLogic.BY_ID, (Enum)FusionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    @NothingNullByDefault
    public static enum FusionReactorLogic implements IReactorLogicMode<FusionReactorLogic>,
    IHasTranslationKey.IHasEnumNameTranslationKey,
    StringRepresentable
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.GUNPOWDER)),
        READY(GeneratorsLang.REACTOR_LOGIC_READY, GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((ItemLike)Items.REDSTONE)),
        CAPACITY(GeneratorsLang.REACTOR_LOGIC_CAPACITY, GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((ItemLike)Items.REDSTONE)),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.REDSTONE));

        public static final Codec<FusionReactorLogic> CODEC;
        public static final IntFunction<FusionReactorLogic> BY_ID;
        public static final StreamCodec<ByteBuf, FusionReactorLogic> STREAM_CODEC;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;
        private final String serializedName;

        private FusionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public Component getDescription() {
            return this.description.translate();
        }

        @Override
        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FusionReactorLogic::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FusionReactorLogic.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

