/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.block.attribute.AttributeStateFissionPortMode;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFissionReactorPort
extends TileEntityFissionReactorCasing {
    private final Map<Direction, BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> capabilityCaches = new EnumMap<Direction, BlockCapabilityCache<IChemicalHandler, Direction>>(Direction.class);
    private final List<BlockCapability<?, @Nullable Direction>> portCapabilities = List.of(Capabilities.CHEMICAL.block(), Capabilities.FLUID.block());
    private final Predicate<AttributeStateFissionPortMode.FissionPortMode> MODE_MATCHES = mode -> mode == this.getMode();

    public TileEntityFissionReactorPort(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FISSION_REACTOR_PORT, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0 && WorldUtils.getBlockState((BlockGetter)this.level, (BlockPos)this.getBlockPos().relative(side)).filter(state -> !state.is(GeneratorsBlocks.FISSION_REACTOR_PORT.getBlock())).isPresent()) {
            return this.getAdjacentUnchecked(side);
        }
        return null;
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getChemicalTanks(this.getMode());
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> this.getMode() == AttributeStateFissionPortMode.FissionPortMode.INPUT ? ((FissionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side) : Collections.emptyList();
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.HEAT || type == ContainerType.CHEMICAL || type == ContainerType.FLUID) {
            return false;
        }
        return super.persists(type);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addChemicalTargetCapability(List<MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateFissionPortMode.FissionPortMode>> outputTargets, Direction side) {
        @Nullable BlockCapabilityCache cache = this.capabilityCaches.get(side);
        if (cache == null) {
            cache = Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.relative(side), side.getOpposite());
            this.capabilityCaches.put(side, (BlockCapabilityCache<IChemicalHandler, Direction>)cache);
        }
        outputTargets.add((MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateFissionPortMode.FissionPortMode>)new MultiblockData.AdvancedCapabilityOutputTarget(cache, this.MODE_MATCHES));
    }

    @ComputerMethod
    AttributeStateFissionPortMode.FissionPortMode getMode() {
        return (AttributeStateFissionPortMode.FissionPortMode)((Object)this.getBlockState().getValue(AttributeStateFissionPortMode.modeProperty));
    }

    @ComputerMethod
    void setMode(AttributeStateFissionPortMode.FissionPortMode mode) {
        if (mode != this.getMode()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(AttributeStateFissionPortMode.modeProperty, (Comparable)((Object)mode)));
            this.invalidateCapabilitiesAll(this.portCapabilities);
        }
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            AttributeStateFissionPortMode.FissionPortMode mode = (AttributeStateFissionPortMode.FissionPortMode)this.getMode().getNext();
            this.setMode(mode);
            player.displayClientMessage((Component)MekanismLang.BOILER_VALVE_MODE_CHANGE.translateColored(EnumColor.GRAY, new Object[]{mode}), true);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public FluidStack insertFluid(int tank, @NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(tank, stack, side, action));
    }

    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(stack, side, action));
    }

    private FluidStack handleValves(@NotNull FluidStack stack, @NotNull Action action, @NotNull FluidStack remainder) {
        if (action.execute() && remainder.getAmount() < stack.getAmount()) {
            ((FissionReactorMultiblockData)this.getMultiblock()).triggerValveTransfer((IMultiblock)this);
        }
        return remainder;
    }

    public int getRedstoneLevel() {
        return ((FissionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public boolean exposesMultiblockToComputer() {
        return false;
    }

    @ComputerMethod
    void incrementMode() {
        this.setMode((AttributeStateFissionPortMode.FissionPortMode)this.getMode().getNext());
    }

    @ComputerMethod
    void decrementMode() {
        this.setMode((AttributeStateFissionPortMode.FissionPortMode)this.getMode().getPrevious());
    }
}

