/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsDataComponents;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class TileEntityFissionReactorLogicAdapter
extends TileEntityFissionReactorCasing
implements IReactorLogic<FissionReactorLogic> {
    public FissionReactorLogic logicType = FissionReactorLogic.DISABLED;
    private RedstoneStatus prevStatus = RedstoneStatus.IDLE;

    public TileEntityFissionReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    @Override
    protected boolean onUpdateServer(FissionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        RedstoneStatus status = this.getStatus();
        if (status != this.prevStatus) {
            Level world = this.getLevel();
            if (world != null) {
                Direction side = multiblock.getOutsideSide(this.worldPosition);
                if (side == null) {
                    world.updateNeighborsAt(this.getBlockPos(), this.getBlockType());
                } else if (!EventHooks.onNeighborNotify((Level)world, (BlockPos)this.worldPosition, (BlockState)this.getBlockState(), EnumSet.of(side), (boolean)false).isCanceled()) {
                    world.neighborChanged(this.worldPosition.relative(side), this.getBlockType(), this.worldPosition);
                }
            }
            this.prevStatus = status;
        }
        return needsPacket;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FissionReactorLogic getMode() {
        return this.logicType;
    }

    public FissionReactorLogic[] getModes() {
        return FissionReactorLogic.values();
    }

    public int getRedstoneLevel(Direction side) {
        return !this.isRemote() && ((FissionReactorMultiblockData)this.getMultiblock()).isPositionOutsideBounds(this.worldPosition.relative(side)) && this.getStatus() == RedstoneStatus.OUTPUTTING ? 15 : 0;
    }

    @ComputerMethod(nameOverride="getRedstoneLogicStatus")
    public RedstoneStatus getStatus() {
        if (this.isRemote()) {
            return this.prevStatus;
        }
        FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            switch (this.logicType.ordinal()) {
                case 1: {
                    if (!this.canFunction()) break;
                    return RedstoneStatus.POWERED;
                }
                case 2: {
                    if (!(multiblock.heatCapacitor.getTemperature() >= 1200.0)) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case 3: {
                    long target = MathUtils.clampToLong((double)((double)multiblock.wasteTank.getCapacity() * MekanismGeneratorsConfig.generators.fissionExcessWasteRatio.get()));
                    if (multiblock.wasteTank.getStored() < target) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case 4: {
                    if (!(multiblock.reactorDamage >= 100.0)) break;
                    return RedstoneStatus.OUTPUTTING;
                }
                case 5: {
                    if (!multiblock.fuelTank.isEmpty()) break;
                    return RedstoneStatus.OUTPUTTING;
                }
            }
        }
        return RedstoneStatus.IDLE;
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FissionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    public boolean supportsMode(IRedstoneControl.RedstoneControl mode) {
        return super.supportsMode(mode) && mode != IRedstoneControl.RedstoneControl.DISABLED;
    }

    public void onPowerChange() {
        FissionReactorMultiblockData multiblock;
        super.onPowerChange();
        if (!this.isRemote() && (multiblock = (FissionReactorMultiblockData)this.getMultiblock()).isFormed() && this.logicType == FissionReactorLogic.ACTIVATION) {
            multiblock.setActive(this.canFunction());
        }
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        super.readSustainedData(provider, nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logic_type", FissionReactorLogic.BY_ID, logicType -> {
            this.logicType = logicType;
        });
    }

    public void writeSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.writeSustainedData(provider, nbtTags);
        NBTUtils.writeEnum((CompoundTag)nbtTags, (String)"logic_type", (Enum)this.logicType);
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(GeneratorsDataComponents.FISSION_LOGIC_TYPE, (Object)this.logicType);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.logicType = (FissionReactorLogic)input.getOrDefault(GeneratorsDataComponents.FISSION_LOGIC_TYPE, (Object)this.logicType);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FissionReactorLogic.BY_ID, (Enum)FissionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableEnum.create(RedstoneStatus.BY_ID, (Enum)RedstoneStatus.IDLE, () -> this.prevStatus, value -> {
            this.prevStatus = value;
        }));
    }

    public boolean canBeMaster() {
        return false;
    }

    @NothingNullByDefault
    public static enum FissionReactorLogic implements IReactorLogicMode<FissionReactorLogic>,
    IHasTranslationKey.IHasEnumNameTranslationKey,
    StringRepresentable
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.GUNPOWDER), EnumColor.DARK_GRAY),
        ACTIVATION(GeneratorsLang.REACTOR_LOGIC_ACTIVATION, GeneratorsLang.DESCRIPTION_REACTOR_ACTIVATION, new ItemStack((ItemLike)Items.FLINT_AND_STEEL), EnumColor.AQUA),
        TEMPERATURE(GeneratorsLang.REACTOR_LOGIC_TEMPERATURE, GeneratorsLang.DESCRIPTION_REACTOR_TEMPERATURE, new ItemStack((ItemLike)Items.REDSTONE), EnumColor.RED),
        CRITICAL_WASTE_LEVEL(GeneratorsLang.REACTOR_LOGIC_CRITICAL_WASTE_LEVEL, GeneratorsLang.DESCRIPTION_REACTOR_CRITICAL_WASTE_LEVEL, new ItemStack((ItemLike)Items.REDSTONE), EnumColor.RED){

            @Override
            @NotNull
            public Component getDescription() {
                return this.description.translate(new Object[]{TextUtils.getPercent((double)MekanismGeneratorsConfig.generators.fissionExcessWasteRatio.get())});
            }
        }
        ,
        DAMAGED(GeneratorsLang.REACTOR_LOGIC_DAMAGED, GeneratorsLang.DESCRIPTION_REACTOR_DAMAGED, new ItemStack((ItemLike)Items.REDSTONE), EnumColor.RED),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.REDSTONE), EnumColor.RED);

        public static final Codec<FissionReactorLogic> CODEC;
        public static final IntFunction<FissionReactorLogic> BY_ID;
        public static final StreamCodec<ByteBuf, FissionReactorLogic> STREAM_CODEC;
        private final ILangEntry name;
        protected final ILangEntry description;
        private final ItemStack renderStack;
        private final EnumColor color;
        private final String serializedName;

        private FissionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack, EnumColor color) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
            this.color = color;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public Component getDescription() {
            return this.description.translate();
        }

        @Override
        public EnumColor getColor() {
            return this.color;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FissionReactorLogic::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FissionReactorLogic.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    @NothingNullByDefault
    public static enum RedstoneStatus implements IHasTranslationKey.IHasEnumNameTranslationKey
    {
        IDLE((ILangEntry)MekanismLang.IDLE),
        OUTPUTTING(GeneratorsLang.REACTOR_LOGIC_OUTPUTTING),
        POWERED(GeneratorsLang.REACTOR_LOGIC_POWERED);

        public static final IntFunction<RedstoneStatus> BY_ID;
        public static final StreamCodec<ByteBuf, RedstoneStatus> STREAM_CODEC;
        private final ILangEntry name;

        private RedstoneStatus(ILangEntry name) {
            this.name = name;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])RedstoneStatus.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

