/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.registries;

import mekanism.api.text.ILangEntry;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismCreativeTabs;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsItems;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class GeneratorsCreativeTabs {
    public static final CreativeTabDeferredRegister CREATIVE_TABS = new CreativeTabDeferredRegister("mekanismgenerators", GeneratorsCreativeTabs::addToExistingTabs);
    public static final MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> GENERATORS = CREATIVE_TABS.registerMain((ILangEntry)GeneratorsLang.MEKANISM_GENERATORS, GeneratorsBlocks.HEAT_GENERATOR, builder -> builder.backgroundTexture(MekanismGenerators.rl("textures/gui/creative_tab.png")).withSearchBar(50).withTabsBefore(new ResourceKey[]{MekanismCreativeTabs.MEKANISM.getKey()}).displayItems((displayParameters, output) -> {
        CreativeTabDeferredRegister.addToDisplay((ItemDeferredRegister)GeneratorsItems.ITEMS, (CreativeModeTab.Output)output);
        CreativeTabDeferredRegister.addToDisplay((BlockDeferredRegister)GeneratorsBlocks.BLOCKS, (CreativeModeTab.Output)output);
        CreativeTabDeferredRegister.addToDisplay((FluidDeferredRegister)GeneratorsFluids.FLUIDS, (CreativeModeTab.Output)output);
    }));

    private static void addToExistingTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tabKey = event.getTabKey();
        if (tabKey == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (ItemLike[])new ItemLike[]{GeneratorsBlocks.HEAT_GENERATOR, GeneratorsBlocks.SOLAR_GENERATOR, GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, GeneratorsBlocks.WIND_GENERATOR, GeneratorsBlocks.BIO_GENERATOR, GeneratorsBlocks.GAS_BURNING_GENERATOR});
        } else if (tabKey == CreativeModeTabs.REDSTONE_BLOCKS) {
            for (Holder blockProvider : GeneratorsBlocks.BLOCKS.getPrimaryEntries()) {
                Block block = (Block)blockProvider.value();
                if (!Attribute.has((Block)block, Attributes.AttributeComparator.class)) continue;
                CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (ItemLike)block);
            }
        } else if (tabKey == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            CreativeTabDeferredRegister.addToDisplay((FluidDeferredRegister)GeneratorsFluids.FLUIDS, (CreativeModeTab.Output)event);
        } else if (tabKey == CreativeModeTabs.INGREDIENTS) {
            CreativeTabDeferredRegister.addToDisplay((CreativeModeTab.Output)event, (ItemLike[])new ItemLike[]{GeneratorsItems.HOHLRAUM, GeneratorsItems.SOLAR_PANEL});
        }
    }
}

