/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import java.util.List;
import java.util.function.Consumer;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.registration.impl.CreativeTabDeferredRegister;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.StorageUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsChemicals;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ItemHohlraum
extends Item
implements CreativeTabDeferredRegister.ICustomCreativeTabContents {
    public ItemHohlraum(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        ChemicalStack storedGas;
        IChemicalHandler gasHandlerItem = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (gasHandlerItem != null && gasHandlerItem.getChemicalTanks() > 0 && !(storedGas = gasHandlerItem.getChemicalInTank(0)).isEmpty()) {
            tooltip.add((Component)MekanismLang.STORED.translate(new Object[]{storedGas, storedGas.getAmount()}));
            if (storedGas.getAmount() == gasHandlerItem.getChemicalTankCapacity(0)) {
                tooltip.add((Component)GeneratorsLang.READY_FOR_REACTION.translateColored(EnumColor.DARK_GREEN));
            } else {
                tooltip.add((Component)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED));
            }
            return;
        }
        tooltip.add((Component)MekanismLang.NO_CHEMICAL.translate());
        tooltip.add((Component)GeneratorsLang.INSUFFICIENT_FUEL.translateColored(EnumColor.DARK_RED));
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        return StorageUtils.getBarWidth((ItemStack)stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return ChemicalUtil.getRGBDurabilityForDisplay((ItemStack)stack);
    }

    public void addItems(Consumer<ItemStack> tabOutput) {
        tabOutput.accept(ChemicalUtil.getFilledVariant((ItemLike)this, GeneratorsChemicals.FUSION_FUEL));
    }
}

