/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.capabilities.chemical.VariableCapacityChemicalTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.attribute.AttributeStateFissionPortMode;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorPort;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidStack;

public class FissionReactorMultiblockData
extends MultiblockData
implements IValveHandler {
    private static final double INVERSE_INSULATION_COEFFICIENT = 10000.0;
    private static final double INVERSE_CONDUCTION_COEFFICIENT = 10.0;
    private static final double waterConductivity = 0.5;
    public static final double MIN_DAMAGE_TEMPERATURE = 1200.0;
    public static final double MAX_DAMAGE_TEMPERATURE = 1800.0;
    public static final double MAX_DAMAGE = 100.0;
    private static final double EXPLOSION_CHANCE = 1.953125E-6;
    private final List<MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateFissionPortMode.FissionPortMode>> chemicalOutputTargets = new ArrayList<MultiblockData.AdvancedCapabilityOutputTarget<IChemicalHandler, AttributeStateFissionPortMode.FissionPortMode>>();
    public final Set<FissionReactorValidator.FormedAssembly> assemblies = new LinkedHashSet<FissionReactorValidator.FormedAssembly>();
    private final List<IChemicalTank> inputTanks;
    private final List<IChemicalTank> outputWasteTanks;
    private final List<IChemicalTank> outputCoolantTanks;
    @ContainerSync(setter="setAssemblies")
    @SyntheticComputerMethod(getter="getFuelAssemblies")
    private int fuelAssemblies = 0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getFuelSurfaceArea")
    public int surfaceArea;
    @ContainerSync
    public final MergedTank coolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getFuel", "getFuelCapacity", "getFuelNeeded", "getFuelFilledPercentage"}, docPlaceholder="fuel tank")
    public final IChemicalTank fuelTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getHeatedCoolant", "getHeatedCoolantCapacity", "getHeatedCoolantNeeded", "getHeatedCoolantFilledPercentage"}, docPlaceholder="heated coolant")
    public final IChemicalTank heatedCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getWaste", "getWasteCapacity", "getWasteNeeded", "getWasteFilledPercentage"}, docPlaceholder="waste tank")
    public final IChemicalTank wasteTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="reactor")
    public final VariableHeatCapacitor heatCapacitor;
    private double biomeAmbientTemp;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss = 0.0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getHeatingRate")
    public long lastBoilRate = 0L;
    @ContainerSync
    @SyntheticComputerMethod(getter="getActualBurnRate", getterDescription="Actual burn rate as it may be lower if say there is not enough fuel")
    public double lastBurnRate = 0.0;
    private boolean clientBurning;
    @ContainerSync
    public double reactorDamage = 0.0;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBurnRate", getterDescription="Configured burn rate")
    public double rateLimit;
    public double burnRemaining;
    public double partialWaste;
    @ContainerSync
    private boolean active;
    @ContainerSync
    private boolean forceDisable;
    private int cooledCoolantCapacity;
    private long heatedCoolantCapacity;
    private long fuelCapacity;
    private AABB hotZone;
    public float prevCoolantScale;
    private float prevFuelScale;
    public float prevHeatedCoolantScale;
    private float prevWasteScale;

    public FissionReactorMultiblockData(TileEntityFissionReactorCasing tile) {
        super((BlockEntity)tile);
        this.rateLimit = MekanismGeneratorsConfig.generators.defaultBurnRate.get();
        this.burnRemaining = 0.0;
        this.partialWaste = 0.0;
        this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.getLevel(), (BlockPos)tile.getBlockPos());
        LongSupplier fuelCapacitySupplier = () -> this.fuelCapacity;
        this.coolantTank = MergedTank.create((IExtendedFluidTank)VariableCapacityFluidTank.input((MultiblockData)this, () -> this.cooledCoolantCapacity, fluid -> fluid.is(FluidTags.WATER), (IContentsListener)this), (IChemicalTank)VariableCapacityChemicalTank.input((MultiblockData)this, () -> this.cooledCoolantCapacity, gas -> gas.has(ChemicalAttributes.CooledCoolant.class), (IContentsListener)this));
        this.fluidTanks.add(this.coolantTank.getFluidTank());
        this.fuelTank = VariableCapacityChemicalTank.input((MultiblockData)this, (LongSupplier)fuelCapacitySupplier, gas -> gas == MekanismChemicals.FISSILE_FUEL.getChemical(), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.createSaveAndComparator());
        this.heatedCoolantTank = VariableCapacityChemicalTank.output((MultiblockData)this, () -> this.heatedCoolantCapacity, gas -> gas == MekanismChemicals.STEAM.get() || gas.has(ChemicalAttributes.HeatedCoolant.class), (IContentsListener)this);
        this.wasteTank = VariableCapacityChemicalTank.output((MultiblockData)this, (LongSupplier)fuelCapacitySupplier, gas -> gas == MekanismChemicals.NUCLEAR_WASTE.getChemical(), (ChemicalAttributeValidator)ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this);
        this.inputTanks = List.of(this.fuelTank, this.coolantTank.getChemicalTank());
        this.outputWasteTanks = List.of(this.wasteTank);
        this.outputCoolantTanks = List.of(this.heatedCoolantTank);
        Collections.addAll(this.chemicalTanks, this.fuelTank, this.heatedCoolantTank, this.wasteTank, this.coolantTank.getChemicalTank());
        this.heatCapacitor = VariableHeatCapacitor.create((double)MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get(), () -> 10.0, () -> 10000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    public void onCreated(Level world) {
        super.onCreated(world);
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.heatCapacitor.setHeatCapacity(MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get() * (double)this.locations.size(), true);
        this.hotZone = AABB.encapsulatingFullBlocks((BlockPos)this.getMinPos().offset(1, 1, 1), (BlockPos)this.getMaxPos().offset(-1, -1, -1));
    }

    public boolean tick(Level world) {
        boolean needsPacket = super.tick(world);
        if (this.isActive()) {
            this.burnFuel(world);
        } else {
            this.lastBurnRate = 0.0;
        }
        if (this.isBurning() != this.clientBurning) {
            needsPacket = true;
            this.clientBurning = this.isBurning();
        }
        this.handleCoolant();
        if (!this.chemicalOutputTargets.isEmpty()) {
            if (!this.heatedCoolantTank.isEmpty()) {
                ChemicalUtil.emit((Collection)this.getActiveOutputs(this.chemicalOutputTargets, (Object)AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT), (IChemicalTank)this.heatedCoolantTank);
            }
            if (!this.wasteTank.isEmpty()) {
                ChemicalUtil.emit((Collection)this.getActiveOutputs(this.chemicalOutputTargets, (Object)AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE), (IChemicalTank)this.wasteTank);
            }
        }
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        this.handleDamage(world);
        this.radiateEntities(world);
        float coolantScale = MekanismUtils.getScale((float)this.prevCoolantScale, (IExtendedFluidTank)this.coolantTank.getFluidTank());
        float fuelScale = MekanismUtils.getScale((float)this.prevFuelScale, (IChemicalTank)this.fuelTank);
        float steamScale = MekanismUtils.getScale((float)this.prevHeatedCoolantScale, (IChemicalTank)this.heatedCoolantTank);
        float wasteScale = MekanismUtils.getScale((float)this.prevWasteScale, (IChemicalTank)this.wasteTank);
        if (MekanismUtils.scaleChanged((float)coolantScale, (float)this.prevCoolantScale) || MekanismUtils.scaleChanged((float)fuelScale, (float)this.prevFuelScale) || MekanismUtils.scaleChanged((float)steamScale, (float)this.prevHeatedCoolantScale) || MekanismUtils.scaleChanged((float)wasteScale, (float)this.prevWasteScale)) {
            needsPacket = true;
            this.prevCoolantScale = coolantScale;
            this.prevFuelScale = fuelScale;
            this.prevHeatedCoolantScale = steamScale;
            this.prevWasteScale = wasteScale;
        }
        return needsPacket;
    }

    protected void updateEjectors(Level world) {
        this.chemicalOutputTargets.clear();
        for (IValveHandler.ValveData valve : this.valves) {
            TileEntityFissionReactorPort tile = (TileEntityFissionReactorPort)WorldUtils.getTileEntity(TileEntityFissionReactorPort.class, (BlockGetter)world, (BlockPos)valve.location);
            if (tile == null) continue;
            tile.addChemicalTargetCapability(this.chemicalOutputTargets, valve.side);
        }
    }

    public List<IChemicalTank> getChemicalTanks(AttributeStateFissionPortMode.FissionPortMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case AttributeStateFissionPortMode.FissionPortMode.INPUT -> this.inputTanks;
            case AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE -> this.outputWasteTanks;
            case AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT -> this.outputCoolantTanks;
        };
    }

    public double simulateEnvironment() {
        double invConduction = 20010.0;
        double tempToTransfer = (this.heatCapacitor.getTemperature() - this.biomeAmbientTemp) / invConduction;
        this.heatCapacitor.handleHeat(-tempToTransfer * this.heatCapacitor.getHeatCapacity());
        return Math.max(tempToTransfer, 0.0);
    }

    public void readUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.readUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            this.prevCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale_alt", scale -> {
            this.prevFuelScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale_2", scale -> {
            this.prevHeatedCoolantScale = scale;
        });
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale_3", scale -> {
            this.prevWasteScale = scale;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"volume", this::setVolume);
        NBTUtils.setFluidStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"fluid", arg_0 -> ((IExtendedFluidTank)this.coolantTank.getFluidTank()).setStack(arg_0));
        NBTUtils.setChemicalStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"chemical", arg_0 -> ((IChemicalTank)this.fuelTank).setStack(arg_0));
        NBTUtils.setChemicalStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"chemical_1", arg_0 -> ((IChemicalTank)this.heatedCoolantTank).setStack(arg_0));
        NBTUtils.setChemicalStackIfPresent((HolderLookup.Provider)provider, (CompoundTag)tag, (String)"chemical_2", arg_0 -> ((IChemicalTank)this.wasteTank).setStack(arg_0));
        this.readValves(tag);
        this.assemblies.clear();
        if (tag.contains("assemblies", 9)) {
            ListTag list = tag.getList("assemblies", 10);
            for (int i = 0; i < list.size(); ++i) {
                FissionReactorValidator.FormedAssembly assembly = FissionReactorValidator.FormedAssembly.read(list.getCompound(i));
                if (assembly == null) continue;
                this.assemblies.add(assembly);
            }
        }
    }

    public void writeUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeUpdateTag(tag, provider);
        tag.putFloat("scale", this.prevCoolantScale);
        tag.putFloat("scale_alt", this.prevFuelScale);
        tag.putFloat("scale_2", this.prevHeatedCoolantScale);
        tag.putFloat("scale_3", this.prevWasteScale);
        tag.putInt("volume", this.getVolume());
        tag.put("fluid", this.coolantTank.getFluidTank().getFluid().saveOptional(provider));
        tag.put("chemical", this.fuelTank.getStack().saveOptional(provider));
        tag.put("chemical_1", this.heatedCoolantTank.getStack().saveOptional(provider));
        tag.put("chemical_2", this.wasteTank.getStack().saveOptional(provider));
        this.writeValves(tag);
        ListTag list = new ListTag();
        for (FissionReactorValidator.FormedAssembly assembly : this.assemblies) {
            list.add((Object)assembly.write());
        }
        tag.put("assemblies", (Tag)list);
    }

    private void handleDamage(Level world) {
        double lastDamage = this.reactorDamage;
        double temp = this.heatCapacitor.getTemperature();
        if (temp > 1200.0) {
            double damageRate = Math.min(temp, 1800.0) / 12000.0;
            this.reactorDamage += damageRate;
        } else {
            double repairRate = (1200.0 - temp) / 120000.0;
            this.reactorDamage = Math.max(0.0, this.reactorDamage - repairRate);
        }
        if (this.reactorDamage >= 100.0 && temp >= 1200.0) {
            if (this.isForceDisabled() && MekanismGeneratorsConfig.generators.fissionMeltdownsEnabled.get()) {
                this.setForceDisable(false);
                this.createMeltdown(world);
            } else if (world.random.nextDouble() < this.reactorDamage / 100.0 * MekanismGeneratorsConfig.generators.fissionMeltdownChance.get()) {
                if (MekanismGeneratorsConfig.generators.fissionMeltdownsEnabled.get()) {
                    this.createMeltdown(world);
                } else {
                    this.setForceDisable(true);
                }
            }
        } else if (this.reactorDamage < 100.0 && temp < 1200.0) {
            this.setForceDisable(false);
        }
        if (this.reactorDamage != lastDamage) {
            this.markDirty();
        }
    }

    private void createMeltdown(Level world) {
        RadiationManager.get().createMeltdown(world, this.getMinPos(), this.getMaxPos(), this.heatCapacitor.getHeat(), 1.953125E-6, MekanismGeneratorsConfig.generators.fissionMeltdownRadius.get(), this.inventoryID);
    }

    public void meltdownHappened(Level world) {
        if (this.isFormed()) {
            IRadiationManager radiationManager = IRadiationManager.INSTANCE;
            if (radiationManager.isRadiationEnabled()) {
                double radiation = this.getTankRadioactivityAndDump(this.fuelTank) + this.getWasteTankRadioactivity(true) + this.getTankRadioactivityAndDump(this.coolantTank.getChemicalTank()) + this.getTankRadioactivityAndDump(this.heatedCoolantTank);
                radiationManager.radiate(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)this.getBounds().getCenter()), radiation *= MekanismGeneratorsConfig.generators.fissionMeltdownRadiationMultiplier.get());
            }
            this.heatedCoolantTank.setEmpty();
            this.active = false;
            this.reactorDamage = MekanismGeneratorsConfig.generators.fissionPostMeltdownDamage.get();
            this.burnRemaining = 0.0;
            this.partialWaste = 0.0;
            this.heatCapacitor.setHeat(this.heatCapacitor.getHeatCapacity() * this.biomeAmbientTemp);
            MultiblockCache cache = MekanismGenerators.fissionReactorManager.getCache(this.inventoryID);
            if (cache != null) {
                cache.sync((MultiblockData)this);
            }
        }
    }

    private double getWasteTankRadioactivity(boolean dump) {
        ChemicalStack stored = this.wasteTank.getStack();
        ChemicalAttributes.Radiation attribute = stored.isEmpty() ? (ChemicalAttributes.Radiation)((Chemical)MekanismChemicals.NUCLEAR_WASTE.get()).get(ChemicalAttributes.Radiation.class) : (ChemicalAttributes.Radiation)stored.get(ChemicalAttributes.Radiation.class);
        if (attribute == null) {
            return 0.0;
        }
        if (dump) {
            this.wasteTank.setEmpty();
        }
        return ((double)stored.getAmount() + this.partialWaste) * attribute.getRadioactivity();
    }

    private double getTankRadioactivityAndDump(IChemicalTank tank) {
        ChemicalStack stored;
        ChemicalAttributes.Radiation attribute;
        if (!tank.isEmpty() && (attribute = (ChemicalAttributes.Radiation)(stored = tank.getStack()).get(ChemicalAttributes.Radiation.class)) != null) {
            tank.setEmpty();
            return (double)stored.getAmount() * attribute.getRadioactivity();
        }
        return 0.0;
    }

    private void handleCoolant() {
        double temp = this.heatCapacitor.getTemperature();
        double heat = this.getBoilEfficiency() * (temp - HeatUtils.BASE_BOIL_TEMP) * this.heatCapacitor.getHeatCapacity();
        switch (this.coolantTank.getCurrentType()) {
            case EMPTY: {
                this.lastBoilRate = 0L;
                break;
            }
            case FLUID: {
                IExtendedFluidTank fluidCoolantTank = this.coolantTank.getFluidTank();
                double caseCoolantHeat = heat * 0.5;
                this.lastBoilRate = this.clampCoolantHeated(HeatUtils.getSteamEnergyEfficiency() * caseCoolantHeat / HeatUtils.getWaterThermalEnthalpy(), fluidCoolantTank.getFluidAmount());
                if (this.lastBoilRate > 0L) {
                    MekanismUtils.logMismatchedStackSize((long)fluidCoolantTank.shrinkStack((int)this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                    this.heatedCoolantTank.insert(MekanismChemicals.STEAM.getStack(this.lastBoilRate), Action.EXECUTE, AutomationType.INTERNAL);
                    caseCoolantHeat = (double)this.lastBoilRate * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                    this.heatCapacitor.handleHeat(-caseCoolantHeat);
                    break;
                }
                this.lastBoilRate = 0L;
                break;
            }
            case CHEMICAL: {
                IChemicalTank chemicalCoolantTank = this.coolantTank.getChemicalTank();
                ChemicalAttributes.CooledCoolant coolantType = (ChemicalAttributes.CooledCoolant)chemicalCoolantTank.getStack().get(ChemicalAttributes.CooledCoolant.class);
                if (coolantType != null) {
                    double caseCoolantHeat = heat * coolantType.getConductivity();
                    this.lastBoilRate = this.clampCoolantHeated(caseCoolantHeat / coolantType.getThermalEnthalpy(), chemicalCoolantTank.getStored());
                    if (this.lastBoilRate <= 0L) break;
                    MekanismUtils.logMismatchedStackSize((long)chemicalCoolantTank.shrinkStack(this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                    this.heatedCoolantTank.insert(coolantType.getHeatedChemical().getStack(this.lastBoilRate), Action.EXECUTE, AutomationType.INTERNAL);
                    caseCoolantHeat = (double)this.lastBoilRate * coolantType.getThermalEnthalpy();
                    this.heatCapacitor.handleHeat(-caseCoolantHeat);
                    break;
                }
                this.lastBoilRate = 0L;
            }
        }
    }

    private long clampCoolantHeated(double heated, long stored) {
        long heatedLong = MathUtils.clampToLong((double)heated);
        if (heatedLong < 0L) {
            return 0L;
        }
        if (heatedLong > stored) {
            return stored;
        }
        return heatedLong;
    }

    private void burnFuel(Level world) {
        double lastPartialWaste = this.partialWaste;
        double lastBurnRemaining = this.burnRemaining;
        double storedFuel = (double)this.fuelTank.getStored() + this.burnRemaining;
        double toBurn = Math.min(Math.min(this.rateLimit, storedFuel), (double)((long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get()));
        this.fuelTank.setStackSize((long)(storedFuel -= toBurn), Action.EXECUTE);
        this.burnRemaining = storedFuel % 1.0;
        this.heatCapacitor.handleHeat(toBurn * (double)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get());
        this.partialWaste += toBurn;
        long newWaste = Mth.lfloor((double)this.partialWaste);
        if (newWaste > 0L) {
            ChemicalAttributes.Radiation attribute;
            this.partialWaste %= 1.0;
            long leftoverWaste = Math.max(0L, newWaste - this.wasteTank.getNeeded());
            ChemicalStack wasteToAdd = MekanismChemicals.NUCLEAR_WASTE.getStack(newWaste);
            this.wasteTank.insert(wasteToAdd, Action.EXECUTE, AutomationType.INTERNAL);
            if (leftoverWaste > 0L && IRadiationManager.INSTANCE.isRadiationEnabled() && (attribute = (ChemicalAttributes.Radiation)wasteToAdd.get(ChemicalAttributes.Radiation.class)) != null) {
                IRadiationManager.INSTANCE.radiate(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)this.getBounds().getCenter()), (double)leftoverWaste * attribute.getRadioactivity());
            }
        }
        this.lastBurnRate = toBurn;
        if (lastPartialWaste != this.partialWaste || lastBurnRemaining != this.burnRemaining) {
            this.markDirty();
        }
    }

    private void radiateEntities(Level world) {
        List entitiesToRadiate;
        IRadiationManager radiationManager = IRadiationManager.INSTANCE;
        if (radiationManager.isRadiationEnabled() && this.isBurning() && world.getRandom().nextInt() % 20 == 0 && !(entitiesToRadiate = this.getLevel().getEntitiesOfClass(LivingEntity.class, this.hotZone)).isEmpty()) {
            double wasteRadiation = this.getWasteTankRadioactivity(false) / 3600.0;
            double magnitude = this.lastBurnRate + wasteRadiation;
            for (LivingEntity entity : entitiesToRadiate) {
                radiationManager.radiate(entity, magnitude);
            }
        }
    }

    void setForceDisable(boolean forceDisable) {
        if (this.forceDisable != forceDisable) {
            this.forceDisable = forceDisable;
            this.markDirty();
            if (this.forceDisable) {
                this.setActive(false);
            }
        }
    }

    @ComputerMethod
    public boolean isForceDisabled() {
        return this.forceDisable;
    }

    @ComputerMethod(nameOverride="getStatus", methodDescription="true -> active, false -> off")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (!(this.active == active || active && this.isForceDisabled())) {
            this.active = active;
            this.markDirty();
        }
    }

    public boolean isBurning() {
        return this.lastBurnRate > 0.0;
    }

    public boolean handlesSound(TileEntityFissionReactorCasing tile) {
        return this.getBounds().isOnCorner(tile.getBlockPos());
    }

    @ComputerMethod
    public double getBoilEfficiency() {
        if (this.fuelAssemblies == 0) {
            return 0.0;
        }
        double avgSurfaceArea = (double)this.surfaceArea / (double)this.fuelAssemblies;
        return Math.min(1.0, avgSurfaceArea / MekanismGeneratorsConfig.generators.fissionSurfaceAreaTarget.get());
    }

    @ComputerMethod
    public long getMaxBurnRate() {
        return (long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get();
    }

    @ComputerMethod
    public long getDamagePercent() {
        return Math.round(this.reactorDamage / 100.0 * 100.0);
    }

    public void setAssemblies(int assemblies) {
        if (this.fuelAssemblies != assemblies) {
            this.fuelAssemblies = assemblies;
            this.fuelCapacity = (long)assemblies * MekanismGeneratorsConfig.generators.maxFuelPerAssembly.get();
        }
    }

    public void setVolume(int volume) {
        if (this.getVolume() != volume) {
            super.setVolume(volume);
            this.cooledCoolantCapacity = volume * MekanismGeneratorsConfig.generators.fissionCooledCoolantPerTank.get();
            this.heatedCoolantCapacity = (long)volume * MekanismGeneratorsConfig.generators.fissionHeatedCoolantPerTank.get();
        }
    }

    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fuelTank.getStored(), (long)this.fuelTank.getCapacity());
    }

    public void setRateLimit(double rate) {
        if (this.rateLimit != (rate = Mth.clamp((double)rate, (double)0.0, (double)this.getMaxBurnRate()))) {
            this.rateLimit = rate;
            this.markDirty();
        }
    }

    @ComputerMethod(methodDescription="Must be disabled, and if meltdowns are disabled must not have been force disabled")
    void activate() throws ComputerException {
        if (this.isActive()) {
            throw new ComputerException("Reactor is already active.");
        }
        if (this.isForceDisabled()) {
            throw new ComputerException("Reactor must reach safe damage and temperature levels before it can be reactivated.");
        }
        this.setActive(true);
    }

    @ComputerMethod(methodDescription="Must be enabled")
    void scram() throws ComputerException {
        if (!this.isActive()) {
            throw new ComputerException("Scram requires the reactor to be active.");
        }
        this.setActive(false);
    }

    @ComputerMethod
    void setBurnRate(double rate) throws ComputerException {
        rate = UnitDisplayUtils.roundDecimals((double)rate);
        long max = this.getMaxBurnRate();
        if (rate < 0.0 || rate > (double)max) {
            throw new ComputerException("Burn Rate '%.2f' is out of range must be between 0 and %d. (Inclusive)", new Object[]{rate, max});
        }
        this.setRateLimit(rate);
    }

    @ComputerMethod
    Either<ChemicalStack, FluidStack> getCoolant() {
        if (this.coolantTank.getCurrentType() == MergedTank.CurrentType.CHEMICAL) {
            return Either.left((Object)this.coolantTank.getChemicalTank().getStack());
        }
        return Either.right((Object)this.coolantTank.getFluidTank().getFluid());
    }

    @ComputerMethod
    long getCoolantCapacity() {
        if (this.coolantTank.getCurrentType() == MergedTank.CurrentType.CHEMICAL) {
            return this.coolantTank.getChemicalTank().getCapacity();
        }
        return this.coolantTank.getFluidTank().getCapacity();
    }

    @ComputerMethod
    long getCoolantNeeded() {
        if (this.coolantTank.getCurrentType() == MergedTank.CurrentType.CHEMICAL) {
            return this.coolantTank.getChemicalTank().getNeeded();
        }
        return this.coolantTank.getFluidTank().getNeeded();
    }

    @ComputerMethod
    double getCoolantFilledPercentage() {
        if (this.coolantTank.getCurrentType() == MergedTank.CurrentType.CHEMICAL) {
            IChemicalTank chemicalCoolantTank = this.coolantTank.getChemicalTank();
            return (double)chemicalCoolantTank.getStored() / (double)chemicalCoolantTank.getCapacity();
        }
        IExtendedFluidTank fluidCoolantTank = this.coolantTank.getFluidTank();
        return (double)fluidCoolantTank.getFluidAmount() / (double)fluidCoolantTank.getCapacity();
    }

    @ComputerMethod
    double getHeatCapacity() {
        return this.heatCapacitor.getHeatCapacity();
    }
}

