/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedDoubleValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.util.EnumUtils;
import mekanism.generators.common.config.GeneratorsConfigTranslations;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GeneratorsConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedLongValue advancedSolarGeneration;
    public final CachedLongValue bioGeneration;
    public final CachedIntValue bioTankCapacity;
    public final CachedLongValue heatGeneration;
    public final CachedLongValue heatGenerationLava;
    public final CachedLongValue heatGenerationNether;
    public final CachedIntValue heatTankCapacity;
    public final CachedIntValue heatGenerationFluidRate;
    public final CachedLongValue gbgTankCapacity;
    public final CachedIntValue etheneBurnTicks;
    public final CachedDoubleValue etheneDensityMultiplier;
    public final CachedLongValue solarGeneration;
    public final CachedIntValue turbineBladesPerCoil;
    public final CachedDoubleValue turbineVentChemicalFlow;
    public final CachedDoubleValue turbineDisperserChemicalFlow;
    public final CachedLongValue turbineEnergyCapacityPerVolume;
    public final CachedLongValue turbineChemicalPerTank;
    public final CachedIntValue condenserRate;
    public final CachedLongValue energyPerFusionFuel;
    public final CachedLongValue windGenerationMin;
    public final CachedLongValue windGenerationMax;
    public final CachedIntValue windGenerationMinY;
    public final CachedIntValue windGenerationMaxY;
    public final CachedLongValue energyPerFissionFuel;
    public final CachedDoubleValue fissionCasingHeatCapacity;
    public final CachedDoubleValue fissionSurfaceAreaTarget;
    public final CachedBooleanValue fissionMeltdownsEnabled;
    public final CachedFloatValue fissionMeltdownRadius;
    public final CachedDoubleValue fissionMeltdownChance;
    public final CachedDoubleValue fissionMeltdownRadiationMultiplier;
    public final CachedDoubleValue fissionPostMeltdownDamage;
    public final CachedDoubleValue defaultBurnRate;
    public final CachedLongValue burnPerAssembly;
    public final CachedLongValue maxFuelPerAssembly;
    public final CachedIntValue fissionCooledCoolantPerTank;
    public final CachedLongValue fissionHeatedCoolantPerTank;
    public final CachedDoubleValue fissionExcessWasteRatio;
    public final CachedLongValue hohlraumMaxGas;
    public final CachedLongValue hohlraumFillRate;
    public final CachedDoubleValue fusionThermocoupleEfficiency;
    public final CachedDoubleValue fusionCasingThermalConductivity;
    public final CachedDoubleValue fusionWaterHeatingRatio;
    public final CachedLongValue fusionFuelCapacity;
    public final CachedLongValue fusionEnergyCapacity;
    public final CachedIntValue fusionWaterPerInjection;
    public final CachedLongValue fusionSteamPerInjection;

    GeneratorsConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        GeneratorsConfigTranslations.SERVER_HOHLRAUM.applyToBuilder(builder).push("hohlraum");
        this.hohlraumMaxGas = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_HOHLRAUM_CAPACITY.applyToBuilder(builder).defineInRange("capacity", 10L, 1L, Long.MAX_VALUE));
        this.hohlraumFillRate = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_HOHLRAUM_FILL_RATE.applyToBuilder(builder).defineInRange("fillRate", 1L, 1L, Long.MAX_VALUE));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_GENERATOR_SOLAR.applyToBuilder(builder).push("solar_generator");
        this.solarGeneration = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_SOLAR_GENERATION, (String)"solarGeneration", (long)50L);
        this.advancedSolarGeneration = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_SOLAR_GENERATION_ADVANCED, (String)"advancedSolarGeneration", (long)300L);
        builder.pop();
        GeneratorsConfigTranslations.SERVER_GENERATOR_BIO.applyToBuilder(builder).push("bio_generator");
        this.bioGeneration = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_BIO_GENERATION, (String)"bioGeneration", (long)350L);
        this.bioTankCapacity = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_BIO_TANK_CAPACITY.applyToBuilder(builder).defineInRange("tankCapacity", 24000, 1, Integer.MAX_VALUE));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT.applyToBuilder(builder).push("heat_generator");
        this.heatGeneration = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT_GENERATION, (String)"heatGeneration", (long)200L);
        this.heatGenerationLava = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT_GEN_LAVA, (String)"heatGenerationLava", (long)30L, (long)0L, (long)(Long.MAX_VALUE / (long)(EnumUtils.DIRECTIONS.length + 1)));
        this.heatGenerationNether = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT_GEN_NETHER, (String)"heatGenerationNether", (long)100L);
        this.heatTankCapacity = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT_TANK_CAPACITY.applyToBuilder(builder).defineInRange("tankCapacity", 24000, 1, Integer.MAX_VALUE));
        this.heatGenerationFluidRate = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_HEAT_FLUID_RATE.applyToBuilder(builder).define("heatGenerationFluidRate", (Object)10, value -> {
            Integer i;
            return value instanceof Integer && (i = (Integer)value) > 0 && i <= this.heatTankCapacity.getOrDefault();
        }));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_GENERATOR_GAS.applyToBuilder(builder).push("gas_generator");
        this.gbgTankCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_GAS_TANK_CAPACITY.applyToBuilder(builder).defineInRange("tankCapacity", 18000L, 1L, Long.MAX_VALUE));
        this.etheneBurnTicks = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_GAS_ETHENE_BURN_TICKS.applyToBuilder(builder).defineInRange("etheneBurnTicks", 40, 1, Integer.MAX_VALUE));
        this.etheneDensityMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_GAS_ETHENE_DENSITY.applyToBuilder(builder).defineInRange("etheneDensityMultiplier", 40.0, 1.0, 2.147483647E9));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_GENERATOR_WIND.applyToBuilder(builder).push("wind_generator");
        this.windGenerationMin = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_WIND_GEN_MIN, (String)"generationMin", (long)60L);
        this.windGenerationMax = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_GENERATOR_WIND_GEN_MAX, (String)"generationMax", (long)480L);
        this.windGenerationMinY = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_WIND_GEN_MIN_Y.applyToBuilder(builder).defineInRange("minY", 24, DimensionType.MIN_Y, DimensionType.MAX_Y - 1));
        this.windGenerationMaxY = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_GENERATOR_WIND_GEN_MAX_Y.applyToBuilder(builder).define("maxY", (Object)DimensionType.MAX_Y, value -> value instanceof Integer && (Integer)value > this.windGenerationMinY.getOrDefault()));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_TURBINE.applyToBuilder(builder).push("turbine");
        this.turbineBladesPerCoil = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_TURBINE_BLADES.applyToBuilder(builder).defineInRange("bladesPerCoil", 4, 1, 12));
        this.turbineVentChemicalFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_TURBINE_RATE_VENT.applyToBuilder(builder).defineInRange("ventChemicalFlow", 32000.0, 0.1, 1024000.0));
        this.turbineDisperserChemicalFlow = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_TURBINE_RATE_DISPERSER.applyToBuilder(builder).defineInRange("disperserChemicalFlow", 1280.0, 0.1, 1024000.0));
        this.condenserRate = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_TURBINE_RATE_CONDENSER.applyToBuilder(builder).defineInRange("condenserRate", 64000, 1, 2000000));
        this.turbineEnergyCapacityPerVolume = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_TURBINE_ENERGY_CAPACITY, (String)"energyCapacityPerVolume", (long)16000000L, (long)1L, (long)1000000000000L);
        int maxTurbine = 5202;
        this.turbineChemicalPerTank = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_TURBINE_CHEMICAL_CAPACITY.applyToBuilder(builder).defineInRange("chemicalPerTank", 64000L, 1L, Long.MAX_VALUE / (long)maxTurbine));
        builder.pop();
        GeneratorsConfigTranslations.SERVER_FISSION.applyToBuilder(builder).push("fission_reactor");
        this.energyPerFissionFuel = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_FISSION_FUEL_ENERGY, (String)"energyPerFissionFuel", (long)1000000L);
        this.fissionCasingHeatCapacity = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION__CASING_HEAT_CAPACITY.applyToBuilder(builder).defineInRange("casingHeatCapacity", 1000.0, 1.0, 1000000.0));
        this.fissionSurfaceAreaTarget = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_SURFACE_AREA.applyToBuilder(builder).defineInRange("surfaceAreaTarget", 4.0, 1.0, Double.MAX_VALUE));
        this.defaultBurnRate = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_DEFAULT_BURN_RATE.applyToBuilder(builder).defineInRange("defaultBurnRate", 0.1, 0.001, 1.0));
        this.burnPerAssembly = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_BURN_PER_ASSEMBLY.applyToBuilder(builder).defineInRange("burnPerAssembly", 1L, 1L, 1000000L));
        this.maxFuelPerAssembly = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_FUEL_CAPACITY.applyToBuilder(builder).defineInRange("maxFuelPerAssembly", 8000L, 1L, 0x7FFFFFFFFFFFFL));
        int maxVolume = 5832;
        this.fissionCooledCoolantPerTank = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_COOLED_COOLANT_CAPACITY.applyToBuilder(builder).defineInRange("cooledCoolantPerTank", 100000, 1, Integer.MAX_VALUE / maxVolume));
        this.fissionHeatedCoolantPerTank = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_HEATED_COOLANT_CAPACITY.applyToBuilder(builder).defineInRange("heatedCoolantPerTank", 1000000L, 1000L, Long.MAX_VALUE / (long)maxVolume));
        this.fissionExcessWasteRatio = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_EXCESS_WASTE.applyToBuilder(builder).defineInRange("excessWaste", 0.9, 0.001, 1.0));
        GeneratorsConfigTranslations.SERVER_FISSION_MELTDOWNS.applyToBuilder(builder).push("meltdowns");
        this.fissionMeltdownsEnabled = CachedBooleanValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_MELTDOWNS_ENABLED.applyToBuilder(builder).define("enabled", true));
        this.fissionMeltdownRadius = CachedFloatValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_MELTDOWNS_RADIUS.applyToBuilder(builder).defineInRange("radius", 8.0, 1.0, 500.0));
        this.fissionMeltdownChance = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_MELTDOWNS_CHANCE.applyToBuilder(builder).defineInRange("chance", 0.001, 0.0, 1.0));
        this.fissionMeltdownRadiationMultiplier = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_MELTDOWNS_RADIATION_MULTIPLIER.applyToBuilder(builder).defineInRange("radiationMultiplier", 50.0, 0.1, 1000000.0));
        this.fissionPostMeltdownDamage = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FISSION_POST_MELTDOWN_DAMAGE.applyToBuilder(builder).defineInRange("postMeltdownDamage", 75.0, 0.0, 100.0));
        builder.pop();
        builder.pop();
        GeneratorsConfigTranslations.SERVER_FUSION.applyToBuilder(builder).push("fusion_reactor");
        this.energyPerFusionFuel = CachedLongValue.definePositive((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_FUSION_FUEL_ENERGY, (String)"fuelEnergy", (long)10000000L);
        this.fusionThermocoupleEfficiency = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_THERMOCOUPLE_EFFICIENCY.applyToBuilder(builder).defineInRange("thermocoupleEfficiency", 0.05, 0.0, 1.0));
        this.fusionCasingThermalConductivity = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_THERMAL_CONDUCTIVITY.applyToBuilder(builder).defineInRange("casingThermalConductivity", 0.1, 0.001, 1.0));
        this.fusionWaterHeatingRatio = CachedDoubleValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_HEATING_RATE.applyToBuilder(builder).defineInRange("waterHeatingRatio", 0.3, 0.0, 1.0));
        this.fusionFuelCapacity = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_FUEL_CAPACITY.applyToBuilder(builder).defineInRange("fuelCapacity", 1000L, 2L, 1000000L));
        this.fusionEnergyCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)GeneratorsConfigTranslations.SERVER_FUSION_ENERGY_CAPACITY, (String)"energyCapacity", (long)1000000000L, (long)1L, (long)Long.MAX_VALUE);
        int baseMaxWater = 1000000;
        this.fusionWaterPerInjection = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_WATER_INJECTION.applyToBuilder(builder).defineInRange("waterPerInjection", 1000000, 1, 21913098));
        this.fusionSteamPerInjection = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)GeneratorsConfigTranslations.SERVER_FUSION_STEAM_INJECTION.applyToBuilder(builder).defineInRange("steamPerInjection", 100L * (long)baseMaxWater, 1L, 94116041192395671L));
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "generators";
    }

    public String getTranslation() {
        return "General Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

