/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public class RenderFissionReactor
extends MultiblockTileEntityRenderer<FissionReactorMultiblockData, TileEntityFissionReactorCasing> {
    private static final Map<RenderData, MekanismRenderer.Model3D> cachedHeatedCoolantModels = new Object2ObjectOpenHashMap();
    private static final int GLOW_ARGB = MekanismRenderer.getColorARGB((float)0.466f, (float)0.882f, (float)0.929f, (float)0.6f);
    private static final MekanismRenderer.LazyModel glowModel = new MekanismRenderer.LazyModel(() -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.whiteIcon).xBounds(0.05f, 0.95f).yBounds(0.01f, 0.99f).zBounds(0.05f, 0.95f).setSideRender(direction -> direction.getAxis().isHorizontal()));

    public static void resetCachedModels() {
        cachedHeatedCoolantModels.clear();
        glowModel.reset();
    }

    public RenderFissionReactor(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityFissionReactorCasing tile, FissionReactorMultiblockData multiblock, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        FluidRenderData data;
        BlockPos pos = tile.getBlockPos();
        VertexConsumer buffer = null;
        if (multiblock.isBurning()) {
            buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
            profiler.push("fissionFuelAssembly");
            MekanismRenderer.Model3D model = glowModel.get();
            Camera camera = this.getCamera();
            for (FissionReactorValidator.FormedAssembly assembly : multiblock.assemblies) {
                BlockPos assemblyPos = assembly.pos();
                matrix.pushPose();
                matrix.translate((float)(assemblyPos.getX() - pos.getX()), (float)(assemblyPos.getY() - pos.getY()), (float)(assemblyPos.getZ() - pos.getZ()));
                matrix.scale(1.0f, (float)assembly.height() + 0.625f, 1.0f);
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)model, (PoseStack)matrix, (VertexConsumer)buffer, (int)GLOW_ARGB, (int)0xF000F0, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)camera, (BlockPos)assemblyPos);
                matrix.popPose();
            }
            profiler.pop();
        }
        if (multiblock.coolantTank.getCurrentType() == MergedTank.CurrentType.FLUID) {
            if (buffer == null) {
                buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
            }
            data = (FluidRenderData)RenderData.Builder.create((FluidStack)multiblock.coolantTank.getFluidTank().getFluid()).of((MultiblockData)multiblock).build();
            this.renderObject((RenderData)data, multiblock.valves, pos, matrix, buffer, overlayLight, multiblock.prevCoolantScale);
        }
        if (!multiblock.heatedCoolantTank.isEmpty()) {
            if (buffer == null) {
                buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
            }
            data = RenderData.Builder.create((ChemicalStack)multiblock.heatedCoolantTank.getStack()).of((MultiblockData)multiblock).build();
            MekanismRenderer.Model3D gasModel = cachedHeatedCoolantModels.computeIfAbsent((RenderData)data, d -> ModelRenderer.getModel((RenderData)d, (double)1.0).copy().shrink(0.01f));
            this.renderObject((RenderData)data, pos, gasModel, matrix, buffer, overlayLight, multiblock.prevHeatedCoolantScale);
        }
    }

    protected String getProfilerSection() {
        return "fissionReactor";
    }
}

