/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.recipe_viewer.recipe;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.HeatUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record FissionRecipeViewerRecipe(ResourceLocation id, @Nullable ChemicalStackIngredient inputCoolant, ChemicalStackIngredient fuel, ChemicalStack outputCoolant, ChemicalStack waste) implements INamedRVRecipe
{
    public FluidStackIngredient waterInput() {
        return IngredientCreatorAccess.fluid().from(FluidTags.WATER, MathUtils.clampToInt((long)this.outputCoolant().getAmount()));
    }

    public static List<FissionRecipeViewerRecipe> getFissionRecipes() {
        ArrayList<FissionRecipeViewerRecipe> recipes = new ArrayList<FissionRecipeViewerRecipe>();
        long energyPerFuel = MekanismGeneratorsConfig.generators.energyPerFissionFuel.get();
        long coolantAmount = Math.round((double)energyPerFuel * HeatUtils.getSteamEnergyEfficiency() / HeatUtils.getWaterThermalEnthalpy());
        recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)MekanismGenerators.rl("water"), (String)"fission"), null, IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)MekanismChemicals.FISSILE_FUEL, 1L), MekanismChemicals.STEAM.getStack(coolantAmount), MekanismChemicals.NUCLEAR_WASTE.getStack(1L)));
        for (Chemical chemical : MekanismAPI.CHEMICAL_REGISTRY) {
            ChemicalAttributes.CooledCoolant cooledCoolant = (ChemicalAttributes.CooledCoolant)chemical.get(ChemicalAttributes.CooledCoolant.class);
            if (cooledCoolant == null) continue;
            Chemical heatedCoolant = cooledCoolant.getHeatedChemical();
            long amount = Math.round((double)energyPerFuel / cooledCoolant.getThermalEnthalpy());
            recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)chemical.getRegistryName(), (String)"fission", (String)"mekanismgenerators"), IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)chemical, amount), IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)MekanismChemicals.FISSILE_FUEL, 1L), heatedCoolant.getStack(amount), MekanismChemicals.NUCLEAR_WASTE.getStack(1L)));
        }
        return recipes;
    }
}

