/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiTurbineStats
extends GuiMekanismTile<TileEntityTurbineCasing, EmptyTileContainer<TileEntityTurbineCasing>> {
    public GuiTurbineStats(EmptyTileContainer<TileEntityTurbineCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.MAIN));
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                storing = EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer);
                double steamPerBlade = (double)MekanismConfig.general.maxEnergyPerSteam.get() / 28.0;
                int bladeCount = Math.min(multiblock.blades, multiblock.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get());
                long producingLong = MathUtils.clampToLong((double)(steamPerBlade * (double)multiblock.clientFlow * (double)bladeCount));
                producing = EnergyDisplay.of((long)producingLong);
            } else {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            }
            return List.of(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
        if (multiblock.isFormed()) {
            MutableComponent limiting = GeneratorsLang.IS_LIMITING.translateColored(EnumColor.DARK_RED);
            int lowerVolume = multiblock.lowerVolume;
            int dispersers = multiblock.getDispersers();
            int vents = multiblock.vents;
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_TANK_VOLUME.translate(new Object[]{lowerVolume}), 8, 26, this.titleTextColor());
            boolean dispersersLimiting = (double)(lowerVolume * dispersers) * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get() < (double)vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get();
            boolean ventsLimiting = (double)(lowerVolume * dispersers) * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get() > (double)vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get();
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_STEAM_FLOW.translate(), 8, 40, this.subheadingTextColor());
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_DISPERSERS.translate(new Object[]{dispersers, dispersersLimiting ? limiting : ""}), 14, 49, this.titleTextColor());
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_VENTS.translate(new Object[]{vents, ventsLimiting ? limiting : ""}), 14, 58, this.titleTextColor());
            int coils = multiblock.coils;
            int blades = multiblock.blades;
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_PRODUCTION.translate(), 8, 72, this.subheadingTextColor());
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_BLADES.translate(new Object[]{blades, coils * 4 > blades ? limiting : ""}), 14, 81, this.titleTextColor());
            this.drawString(guiGraphics, (Component)GeneratorsLang.TURBINE_COILS.translate(new Object[]{coils, coils * 4 < blades ? limiting : ""}), 14, 90, this.titleTextColor());
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.TURBINE_MAX_PRODUCTION.translate(new Object[]{EnergyDisplay.of((long)multiblock.getMaxProduction())}), 8.0f, 104.0f, this.titleTextColor(), 164.0f);
            this.drawTextScaledBound(guiGraphics, (Component)GeneratorsLang.TURBINE_MAX_WATER_OUTPUT.translate(new Object[]{TextUtils.format((long)multiblock.getMaxWaterOutput())}), 8.0f, 113.0f, this.titleTextColor(), 164.0f);
        }
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

