/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.element.GuiTurbineTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiIndustrialTurbine
extends GuiMekanismTile<TileEntityTurbineCasing, MekanismTileContainer<TileEntityTurbineCasing>> {
    public GuiIndustrialTurbine(MekanismTileContainer<TileEntityTurbineCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.inventoryLabelY += 2;
        this.titleLabelY = 5;
        this.dynamicSlots = true;
    }

    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiInnerScreen((IGuiWrapper)this, 50, 18, 112, 50, () -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                list.add(GeneratorsLang.TURBINE_PRODUCTION_AMOUNT.translate(new Object[]{EnergyDisplay.of((long)multiblock.getProductionRate())}));
                list.add(GeneratorsLang.TURBINE_FLOW_RATE.translate(new Object[]{TextUtils.format((long)multiblock.clientFlow)}));
                list.add(GeneratorsLang.TURBINE_CAPACITY.translate(new Object[]{TextUtils.format((long)multiblock.getSteamCapacity())}));
                list.add(GeneratorsLang.TURBINE_MAX_FLOW.translate(new Object[]{TextUtils.format((long)multiblock.getMaxFlowRate())}));
            }
            return list;
        }));
        this.addRenderableWidget((GuiElement)new GuiTurbineTab((IGuiWrapper)this, (TileEntityTurbineCasing)this.tile, GuiTurbineTab.TurbineTab.STAT));
        this.addRenderableWidget((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (multiblock.isFormed()) {
                    return EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer).getTextComponent();
                }
                return EnergyDisplay.ZERO.getTextComponent();
            }

            public double getLevel() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (multiblock.isFormed()) {
                    return MathUtils.divideToLevel((double)multiblock.energyContainer.getEnergy(), (double)multiblock.energyContainer.getMaxEnergy());
                }
                return 1.0;
            }
        }, 164, 16));
        this.addRenderableWidget((GuiElement)new GuiVerticalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return GeneratorsLang.TURBINE_STEAM_INPUT_RATE.translate(new Object[]{TextUtils.format((long)((TurbineMultiblockData)((TileEntityTurbineCasing)((GuiIndustrialTurbine)GuiIndustrialTurbine.this).tile).getMultiblock()).lastSteamInput)});
            }

            public double getLevel() {
                TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)GuiIndustrialTurbine.this.tile).getMultiblock();
                if (!multiblock.isFormed()) {
                    return 0.0;
                }
                double rate = Math.min((double)(multiblock.lowerVolume * multiblock.getDispersers()) * MekanismGeneratorsConfig.generators.turbineDisperserChemicalFlow.get(), (double)multiblock.vents * MekanismGeneratorsConfig.generators.turbineVentChemicalFlow.get());
                if (rate == 0.0) {
                    return 0.0;
                }
                return Math.min(1.0, (double)multiblock.lastSteamInput / rate);
            }
        }, 40, 13));
        this.addRenderableWidget((GuiElement)new GuiChemicalGauge(() -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).chemicalTank, () -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).getChemicalTanks(null), GaugeType.MEDIUM, (IGuiWrapper)this, 6, 13));
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
            EnergyDisplay producing;
            EnergyDisplay storing;
            TurbineMultiblockData multiblock = (TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock();
            if (multiblock.isFormed()) {
                storing = EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer);
                double steamPerBlade = (double)MekanismConfig.general.maxEnergyPerSteam.get() / 28.0;
                int bladesSupported = multiblock.coils * MekanismGeneratorsConfig.generators.turbineBladesPerCoil.get();
                int generationLimiter = Math.min(multiblock.blades, bladesSupported);
                producing = EnergyDisplay.of((long)MathUtils.clampToLong((double)(steamPerBlade * (double)(multiblock.clientFlow * (long)generationLimiter))));
            } else {
                storing = EnergyDisplay.ZERO;
                producing = EnergyDisplay.ZERO;
            }
            return List.of(MekanismLang.STORING.translate(new Object[]{storing}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{producing}));
        }));
        MutableComponent warning = GeneratorsLang.TURBINE_DUMPING_STEAM_WARNING.translateColored(EnumColor.RED);
        this.addRenderableWidget((GuiElement)new GuiGasMode((IGuiWrapper)this, 159, 72, true, () -> ((TurbineMultiblockData)((TileEntityTurbineCasing)this.tile).getMultiblock()).dumpMode, ((TileEntityTurbineCasing)this.tile).getBlockPos(), 0, TooltipUtils.create((Component[])new Component[]{GeneratorsLang.TURBINE_DUMPING_EXCESS_STEAM.translate(), warning}), TooltipUtils.create((Component[])new Component[]{GeneratorsLang.TURBINE_DUMPING_STEAM.translate(), warning})));
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

