/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class TreeFromStructureNBTFeature
extends Feature<TreeFromStructureNBTConfig> {
    private static final boolean DEBUG = false;

    public TreeFromStructureNBTFeature(Codec<TreeFromStructureNBTConfig> $$0) {
        super($$0);
    }

    public boolean place(FeaturePlaceContext<TreeFromStructureNBTConfig> featurePlaceContext) {
        TreeFromStructureNBTConfig config = (TreeFromStructureNBTConfig)featurePlaceContext.config();
        BlockStateProvider logProvider = config.logProvider();
        BlockStateProvider leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.level();
        StructureTemplateManager templateManager = level.getLevel().getStructureManager();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.get(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.get(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeature.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.palettes;
        List canopyPalettes = canopyTemplate.palettes;
        BlockPos origin = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().setRotation(Rotation.getRandom((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.getRandomPalette(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.getRandomPalette(canopyPalettes, origin);
        List center = trunkBasePalette.blocks(Blocks.WHITE_WOOL);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.getFirst()).pos();
        centerOffset = new BlockPos(-centerOffset.getX(), 0, -centerOffset.getZ());
        List<StructureTemplate.StructureBlockInfo> logs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.blocks(Blocks.RED_WOOL);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        HashSet<BlockPos> leavePositions = new HashSet<BlockPos>();
        HashSet<BlockPos> trunkPositions = new HashSet<BlockPos>();
        int trunkLength = config.height().sample(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            if (TreeFromStructureNBTFeature.isOnGround(config.maxLogDepth(), level, pos, config.growableOn())) continue;
            return false;
        }
        TreeFromStructureNBTFeature.placeTrunk(config, logProvider, leavesProvider, level, origin, random, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, trunkPositions, maxTrunkBuildingDepth);
        List canopyAnchor = trunkBasePalette.blocks(Blocks.YELLOW_WOOL);
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, TreeFromStructureNBTFeature.getModifiedPos(placeSettings, (StructureTemplate.StructureBlockInfo)canopyAnchor.getFirst(), centerOffset, origin), random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        } else {
            TreeFromStructureNBTFeature.placeCanopy(config, logProvider, leavesProvider, level, origin, random, placeSettings, randomCanopyPalette, leavePositions, trunkPositions, trunkLength, config.growableOn());
        }
        TreeFromStructureNBTFeature.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions, trunkPositions);
        return true;
    }

    public static void placeAdditional(TreeFromStructureNBTConfig config, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette palette, BlockPos centerOffset) {
        List<StructureTemplate.StructureBlockInfo> additionalBlocks = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.placeFromNBT(), palette);
        for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocks) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
            level.setBlock(pos, additionalBlock.state(), 2);
        }
    }

    public static void placeTrunk(TreeFromStructureNBTConfig config, BlockStateProvider logProvider, BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, StructureTemplate.Palette trunkBasePalette, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, List<StructureTemplate.StructureBlockInfo> logBuilders, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, int maxTrunkBuildingDepth) {
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn());
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, centerOffset, logs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, trunkBasePalette, centerOffset);
    }

    public static void placeCanopy(TreeFromStructureNBTConfig config, BlockStateProvider logProvider, BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, int trunkLength, BlockPredicate groundFilter) {
        List<StructureTemplate.StructureBlockInfo> leaves = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.leavesTarget(), randomCanopyPalette);
        List<StructureTemplate.StructureBlockInfo> canopyLogs = TreeFromStructureNBTFeature.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.blocks(Blocks.WHITE_WOOL);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.getFirst();
        BlockPos canopyCenterOffset = structureBlockInfo.pos();
        canopyCenterOffset = new BlockPos(-canopyCenterOffset.getX(), trunkLength, -canopyCenterOffset.getZ());
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.blocks(Blocks.RED_WOOL));
        TreeFromStructureNBTFeature.fillLogsUnder(random, logProvider, level, origin, placeSettings, canopyCenterOffset, trunkFillers, trunkLength + 1, BlockPredicate.matchesBlocks((Block[])config.logTarget().toArray(new Block[0])));
        TreeFromStructureNBTFeature.placeLogsWithRotation(logProvider, level, origin, random, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions);
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, random, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter());
        TreeFromStructureNBTFeature.placeAdditional(config, level, origin, placeSettings, randomCanopyPalette, canopyCenterOffset);
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Set<BlockPos> trunkPositions) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            level.setBlock(pos, TreeFromStructureNBTFeature.getTransformedState(pos, logProvider.getState(random, pos), trunk.state(), placeSettings.getRotation(), level), 2);
            trunkPositions.add(pos);
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.place(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> level.setBlock(pos, state, 2), random, trunkPositions, leavePositions, new HashSet()));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(BlockStateProvider leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<StructureTemplate.StructureBlockInfo> leaves, Set<BlockPos> leavePositions, BlockPos canopyCenterOffset, BlockPredicate leavesPlacementFilter) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leaves.size());
        for (StructureTemplate.StructureBlockInfo leaf : leaves) {
            BlockPos modifiedPos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
            if (!leavesPlacementFilter.test((Object)level, (Object)modifiedPos)) continue;
            BlockState state = TreeFromStructureNBTFeature.getTransformedState(modifiedPos, leavesProvider.getState(random, modifiedPos), leaf.state(), placeSettings.getRotation(), level);
            level.setBlock(modifiedPos, state, 2);
            BlockState finalState = state;
            if (state.hasProperty((Property)LeavesBlock.DISTANCE)) {
                Runnable postProcess = () -> {
                    BlockState blockState = LeavesBlock.updateDistance((BlockState)finalState, (LevelAccessor)level, (BlockPos)modifiedPos);
                    if ((Integer)blockState.getValue((Property)LeavesBlock.DISTANCE) < 7) {
                        leavePositions.add(modifiedPos);
                        if (blockState.hasProperty((Property)LeavesBlock.PERSISTENT)) {
                            blockState = (BlockState)blockState.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false));
                        }
                        level.setBlock(modifiedPos, blockState, 2);
                        level.scheduleTick(modifiedPos, blockState.getBlock(), 0);
                    } else {
                        level.removeBlock(modifiedPos, false);
                    }
                };
                leavesPostApply.add(postProcess);
                continue;
            }
            leavePositions.add(modifiedPos);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void fillLogsUnder(RandomSource randomSource, BlockStateProvider logProvider, WorldGenLevel level, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, BlockPredicate groundFilter) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeature.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (!groundFilter.test((Object)level, (Object)mutableBlockPos) && !level.getBlockState((BlockPos)mutableBlockPos).is(Blocks.BEDROCK)) {
                    if (level instanceof Level) {
                        level.removeBlock((BlockPos)mutableBlockPos, true);
                    }
                } else {
                    ((RandomTickScheduler)level.getChunk((BlockPos)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.immutable());
                    continue block0;
                }
                BlockState state = logProvider.getState(randomSource, (BlockPos)mutableBlockPos);
                state = Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)level, (BlockPos)mutableBlockPos);
                level.setBlock((BlockPos)mutableBlockPos, state, 2);
                mutableBlockPos.move(Direction.DOWN);
            }
        }
    }

    @NotNull
    public static BlockState getTransformedState(BlockPos modifiedPos, BlockState state, BlockState nbtState, Rotation rotation, WorldGenLevel level) {
        for (Property property : state.getProperties()) {
            if (!nbtState.hasProperty(property)) continue;
            Comparable value = nbtState.getValue(property);
            state = (BlockState)state.setValue(property, value);
        }
        if (state.hasProperty((Property)LeavesBlock.WATERLOGGED)) {
            FluidState fluidState = level.getFluidState(modifiedPos);
            state = fluidState.is((Fluid)Fluids.WATER) && fluidState.getAmount() >= 7 ? (BlockState)state.setValue((Property)LeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)LeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        state = state.rotate(rotation);
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos, BlockPredicate growableOn) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.move(Direction.DOWN);
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)placing.pos()).offset((Vec3i)featureOrigin).offset((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<StructureTemplate.StructureBlockInfo> getStructureInfosInStructurePalletteFromBlockList(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<StructureTemplate.StructureBlockInfo> result = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Block block : blocks) {
            result.addAll(palette.blocks(block));
        }
        return result;
    }
}

