/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features.placementmodifiers;

import com.mojang.serialization.MapCodec;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacementModifiers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.neoforge.common.Tags;

public class BiomeDensityPlacementFilter
extends PlacementFilter {
    private static final BiomeDensityPlacementFilter INSTANCE = new BiomeDensityPlacementFilter();
    public static MapCodec<BiomeDensityPlacementFilter> CODEC = MapCodec.unit(() -> INSTANCE);

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos pos) {
        Holder biome = context.getLevel().getBiome(pos);
        if (biome.is(Tags.Biomes.IS_PLAINS) || biome.is(BiomeTags.IS_SAVANNA) || biome.is(Biomes.MEADOW) || biome.is(Tags.Biomes.IS_SPARSE_VEGETATION)) {
            return random.nextBoolean();
        }
        if (biome.is(Biomes.WINDSWEPT_HILLS) || biome.is(Biomes.WINDSWEPT_GRAVELLY_HILLS)) {
            return random.nextBoolean();
        }
        return true;
    }

    public static BiomeDensityPlacementFilter filter() {
        return INSTANCE;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PVJPlacementModifiers.VEGETATION_DENSITY.get();
    }
}

