/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BeachedKelpBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.properties.BeachedKelpShape;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class BeachedKelpFeature
extends Feature<BlockStateConfiguration> {
    public BeachedKelpFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        int length;
        BlockStateConfiguration config = (BlockStateConfiguration)context.config();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        WorldGenLevel level = context.level();
        BlockState state = config.state;
        if (!(config.state.getBlock() instanceof BeachedKelpBlock)) {
            return false;
        }
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        boolean hasSpace = this.checkHasSpace(level, origin, direction, length = random.nextInt(4));
        if (!hasSpace) {
            return false;
        }
        state = (BlockState)state.setValue((Property)BeachedKelpBlock.FACING, (Comparable)direction);
        BlockPos.MutableBlockPos pos = origin.mutable();
        level.setBlock((BlockPos)pos, (BlockState)state.setValue(BeachedKelpBlock.KELP_SHAPE, (Comparable)((Object)BeachedKelpShape.TOP)), 2);
        for (int i = 0; i < length; ++i) {
            pos.move(direction.getOpposite());
            level.setBlock((BlockPos)pos, (BlockState)state.setValue(BeachedKelpBlock.KELP_SHAPE, (Comparable)((Object)BeachedKelpShape.STRAIGHT)), 2);
        }
        if (random.nextFloat() < 0.2f) {
            pos.move(direction.getOpposite());
            level.setBlock((BlockPos)pos, (BlockState)state.setValue(BeachedKelpBlock.KELP_SHAPE, (Comparable)((Object)BeachedKelpShape.CURVED)), 2);
            pos.move(direction.getCounterClockWise());
            level.setBlock((BlockPos)pos, (BlockState)state.setValue(BeachedKelpBlock.KELP_SHAPE, (Comparable)((Object)BeachedKelpShape.END)), 2);
        }
        return true;
    }

    private boolean checkHasSpace(WorldGenLevel level, BlockPos origin, Direction direction, int length) {
        int totalLength = length + 2;
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (int i = 0; i < totalLength; ++i) {
            if (level.isEmptyBlock((BlockPos)(pos = pos.move(direction.getOpposite()))) && Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below())) continue;
            return false;
        }
        pos.move(direction.getCounterClockWise());
        return level.isEmptyBlock((BlockPos)pos) && Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below());
    }
}

