/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class AntiRepostWarning {
    public static void run() {
        if (PlatHelper.isDev()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Set reposted = Moonlight.getDependents().stream().filter(AntiRepostWarning::isFileNameSus).collect(Collectors.toSet());
        try {
            for (String m : reposted) {
                String url = PlatHelper.getModPageUrl(m);
                if (url == null) {
                    url = "https://curseforge.com/minecraft/mc-mods";
                }
                MutableComponent link = Component.translatable((String)"message.moonlight.anti_repost_link");
                String modName = PlatHelper.getModName(m);
                MutableComponent name = Component.literal((String)modName).withStyle(ChatFormatting.BOLD);
                ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
                link.setStyle(link.getStyle().withClickEvent(click).withUnderlined(Boolean.valueOf(true)).withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD)));
                player.displayClientMessage((Component)Component.translatable((String)"message.moonlight.anti_repost", (Object[])new Object[]{name, link}), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isFileNameSus(String mod) {
        Path path = PlatHelper.getModFilePath(mod);
        if (path == null || path.getFileName() == null) {
            Moonlight.LOGGER.warn("Failed to get file path of mod {}: {}. Oh well.", (Object)mod, (Object)path);
        } else {
            String fileName = path.getFileName().toString();
            if (fileName.contains(".jar")) {
                return fileName.contains("-Mod-") || fileName.endsWith("-tw");
            }
        }
        return false;
    }
}

