/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.neoforge.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final WeakHashMap<RegistryAccess, Map<Fluid, Holder<SoftFluid>>> FLUID_MAP = new WeakHashMap();
    private static final WeakHashMap<RegistryAccess, Map<Item, Holder<SoftFluid>>> ITEM_MAP = new WeakHashMap();

    public static Holder<SoftFluid> fromVanillaFluid(Fluid fluid, RegistryAccess registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static Holder<SoftFluid> fromVanillaItem(Item item, RegistryAccess registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateSlaveMaps(RegistryAccess registryAccess) {
        Map fludiMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        Map itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        fludiMap.clear();
        itemMap.clear();
        for (Holder.Reference<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.value();
            if (!s.isEnabled()) continue;
            for (Holder eq : s.getEquivalentFluids()) {
                Fluid value = (Fluid)eq.value();
                if (value == Fluids.EMPTY) {
                    Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", h);
                    if (PlatHelper.isDev()) {
                        throw new AssertionError((Object)("Invalid fluid for fluid. This is a bug! " + String.valueOf(h)));
                    }
                }
                fludiMap.put(value, h);
            }
            s.getEquivalentFluids().forEach(f -> fludiMap.put((Fluid)f.value(), h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.POTION || !BuiltInSoftFluids.WATER.is((Holder<SoftFluid>)h)) {
                    if (i == Items.AIR) {
                        Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", (Object)h);
                        if (PlatHelper.isDev()) {
                            throw new AssertionError((Object)("Invalid item for fluid. This is a bug! " + String.valueOf(h)));
                        }
                    }
                    itemMap.put(i, h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        for (SoftFluid f : SoftFluidRegistry.getValues()) {
            f.afterInit();
        }
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer() {
        RegistryAccess reg = Utils.hackyGetRegistryAccess();
        SoftFluidInternal.populateSlaveMaps(reg);
        SoftFluidInternal.registerExistingVanillaFluids(FLUID_MAP.get(reg), ITEM_MAP.get(reg));
        for (SoftFluid f : SoftFluidRegistry.getValues()) {
            f.afterInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(fluidMap, (Map<Item, Holder<SoftFluid>>)var1_1);
    }
}

