/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

public class DispenserHelper {
    private static final Map<Item, List<DispenseItemBehavior>> MODDED_BEHAVIORS = new HashMap<Item, List<DispenseItemBehavior>>();
    private static final Map<Item, List<DispenseItemBehavior>> STATIC_MODDED_BEHAVIORS = new HashMap<Item, List<DispenseItemBehavior>>();
    private static final Map<Priority, List<Consumer<Event>>> EVENT_LISTENERS = Map.of(Priority.LOW, new ArrayList(), Priority.NORMAL, new ArrayList(), Priority.HIGH, new ArrayList());
    @Deprecated(forRemoval=true)
    public static final DefaultDispenseItemBehavior PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final DefaultDispenseItemBehavior SHOOT_BEHAVIOR = new DefaultDispenseItemBehavior();

    public static void addListener(Consumer<Event> listener, Priority priority) {
        EVENT_LISTENERS.get((Object)priority).add(listener);
    }

    @ApiStatus.Internal
    public static void reload(final RegistryAccess registryAccess, boolean isClient) {
        Item item;
        final HashSet<Item> failed = new HashSet<Item>();
        HashMap<Item, DispenseItemBehavior> originals = new HashMap<Item, DispenseItemBehavior>();
        for (Map.Entry<Item, List<DispenseItemBehavior>> entry : MODDED_BEHAVIORS.entrySet()) {
            item = entry.getKey();
            if (STATIC_MODDED_BEHAVIORS.containsKey(item)) continue;
            ReferenceOpenHashSet expected = new ReferenceOpenHashSet((Collection)entry.getValue());
            DispenseItemBehavior current = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(item);
            if (current instanceof AdditionalDispenserBehavior) {
                AdditionalDispenserBehavior behavior = (AdditionalDispenserBehavior)current;
                ReferenceOpenHashSet visited = new ReferenceOpenHashSet();
                DispenseItemBehavior original = DispenserHelper.unwrapBehavior(behavior, (Set<AdditionalDispenserBehavior>)visited);
                if (expected.contains((Object)original)) {
                    expected.remove((Object)original);
                    original = null;
                }
                if (expected.equals((Object)visited)) {
                    originals.put(item, original);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to unwrap original behavior for item: {}, {}, {}", (Object)item, (Object)current, (Object)expected);
                failed.add(item);
                continue;
            }
            if (expected.size() == 1 && expected.stream().findAny().get() == current) {
                originals.put(item, null);
                continue;
            }
            failed.add(item);
            Moonlight.LOGGER.error("Failed to restore original behavior for item: {}, {}", (Object)item, (Object)current);
        }
        for (Map.Entry<Object, List<Object>> entry : originals.entrySet()) {
            item = (Item)entry.getKey();
            DispenseItemBehavior behavior = (DispenseItemBehavior)entry.getValue();
            if (behavior != null) {
                DispenserBlock.registerBehavior((ItemLike)item, (DispenseItemBehavior)behavior);
                continue;
            }
            DispenserBlock.DISPENSER_REGISTRY.remove(item);
        }
        MODDED_BEHAVIORS.clear();
        failed.addAll(STATIC_MODDED_BEHAVIORS.keySet());
        Event event = new Event(){

            @Override
            public void register(Item i, DispenseItemBehavior behavior) {
                if (!failed.contains(i)) {
                    MODDED_BEHAVIORS.computeIfAbsent(i, k -> new ArrayList()).add(behavior);
                    DispenserBlock.registerBehavior((ItemLike)i, (DispenseItemBehavior)behavior);
                }
            }

            @Override
            public RegistryAccess getRegistryAccess() {
                return registryAccess;
            }
        };
        EVENT_LISTENERS.get((Object)Priority.LOW).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.NORMAL).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.HIGH).forEach(l -> l.accept(event));
    }

    private static DispenseItemBehavior unwrapBehavior(AdditionalDispenserBehavior behavior, Set<AdditionalDispenserBehavior> visited) {
        visited.add(behavior);
        DispenseItemBehavior inner = behavior.fallback;
        if (inner instanceof AdditionalDispenserBehavior) {
            AdditionalDispenserBehavior ab = (AdditionalDispenserBehavior)inner;
            return DispenserHelper.unwrapBehavior(ab, visited);
        }
        return inner;
    }

    @Deprecated(forRemoval=true)
    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        DispenserBlock.registerBehavior((ItemLike)behavior.item, (DispenseItemBehavior)behavior);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(behavior.item, k -> new ArrayList()).add(behavior);
    }

    @Deprecated(forRemoval=true)
    public static void registerPlaceBlockBehavior(ItemLike block) {
        DispenserBlock.registerBehavior((ItemLike)block, (DispenseItemBehavior)PLACE_BLOCK_BEHAVIOR);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(block.asItem(), k -> new ArrayList()).add(PLACE_BLOCK_BEHAVIOR);
    }

    public static abstract class AdditionalDispenserBehavior
    implements DispenseItemBehavior {
        private final DispenseItemBehavior fallback;
        private final Item item;

        protected AdditionalDispenserBehavior(Item item) {
            this.item = item;
            this.fallback = DispenserBlockAccessor.getDispenserRegistry().get(item);
        }

        public final ItemStack dispense(BlockSource source, ItemStack stack) {
            try {
                InteractionResultHolder<ItemStack> result = this.customBehavior(source, stack);
                InteractionResult type = result.getResult();
                if (type != InteractionResult.PASS) {
                    boolean success = type.consumesAction();
                    this.playSound(source, success);
                    this.playAnimation(source, (Direction)source.state().getValue((Property)DispenserBlock.FACING));
                    if (success) {
                        ItemStack resultStack = (ItemStack)result.getObject();
                        if (resultStack.getItem() == stack.getItem()) {
                            return resultStack;
                        }
                        return this.fillItemInDispenser(source, stack, (ItemStack)result.getObject());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.dispense(source, stack);
        }

        protected abstract InteractionResultHolder<ItemStack> customBehavior(BlockSource var1, ItemStack var2);

        protected void playSound(BlockSource source, boolean success) {
            source.level().levelEvent(success ? 1000 : 1001, source.pos(), 0);
        }

        protected void playAnimation(BlockSource source, Direction direction) {
            source.level().levelEvent(2000, source.pos(), direction.get3DDataValue());
        }

        private ItemStack fillItemInDispenser(BlockSource source, ItemStack empty, ItemStack filled) {
            empty.shrink(1);
            if (empty.isEmpty()) {
                return filled.copy();
            }
            if (!this.mergeDispenserItem(source.blockEntity(), filled)) {
                SHOOT_BEHAVIOR.dispense(source, filled.copy());
            }
            return empty;
        }

        private boolean mergeDispenserItem(DispenserBlockEntity te, ItemStack filled) {
            NonNullList<ItemStack> stacks = ((DispenserBlockEntityAccessor)te).getItems();
            for (int i = 0; i < te.getContainerSize(); ++i) {
                ItemStack s = (ItemStack)stacks.get(i);
                if (!s.isEmpty() && (s.getItem() != filled.getItem() || s.getMaxStackSize() <= s.getCount())) continue;
                filled.grow(s.getCount());
                te.setItem(i, filled);
                return true;
            }
            return false;
        }
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }

    public static interface Event {
        public void register(Item var1, DispenseItemBehavior var2);

        default public void register(AdditionalDispenserBehavior behavior) {
            this.register(behavior.item, behavior);
        }

        default public void registerPlaceBlock(ItemLike i) {
            this.register(i.asItem(), new PlaceBlockBehavior(i.asItem()));
        }

        public RegistryAccess getRegistryAccess();
    }

    @Deprecated(forRemoval=true)
    public static class PlaceBlockDispenseBehavior
    extends OptionalDispenseItemBehavior {
        public ItemStack execute(BlockSource source, ItemStack stack) {
            this.setSuccess(false);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = source.pos().relative(direction);
                Direction direction1 = direction;
                InteractionResult result = bi.place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.level(), blockpos, direction, stack, direction1));
                this.setSuccess(result.consumesAction());
            }
            return stack;
        }
    }

    public static class FillFluidHolderBehavior
    extends AdditionalDispenserBehavior {
        public FillFluidHolderBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            BlockEntity te = source.level().getBlockEntity(blockpos);
            if (te instanceof ISoftFluidTankProvider) {
                ItemStack returnStack;
                SoftFluidTank tank;
                ISoftFluidTankProvider tile = (ISoftFluidTankProvider)te;
                if (tile.canInteractWithSoftFluidTank() && !(tank = tile.getSoftFluidTank()).isFull() && (returnStack = tank.interactWithItem(stack, (Level)source.level(), blockpos, false)) != null) {
                    te.setChanged();
                    return InteractionResultHolder.success((Object)returnStack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
    }

    public static class PlaceBlockBehavior
    extends AdditionalDispenserBehavior {
        public PlaceBlockBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos blockpos = source.pos().relative(direction);
                InteractionResult result = bi.place((BlockPlaceContext)new DirectionalPlaceContext((Level)source.level(), blockpos, direction, stack, direction));
                InteractionResultHolder res = new InteractionResultHolder(result, (Object)stack);
                if (result.consumesAction()) {
                    return res;
                }
            }
            return InteractionResultHolder.pass((Object)stack);
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(Item item) {
            super(item);
        }

        @Override
        protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerLevel world = source.level();
            BlockEntity te = world.getBlockEntity(blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
            if (te instanceof WorldlyContainer) {
                WorldlyContainer tile = (WorldlyContainer)te;
                if (tile.canPlaceItem(0, stack)) {
                    if (tile.isEmpty()) {
                        tile.setItem(0, stack.split(1));
                    } else {
                        tile.getItem(0).grow(1);
                        stack.shrink(1);
                    }
                    return InteractionResultHolder.success((Object)stack);
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
    }
}

