/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.moonlight.api.trades.NoOpListing;
import net.mehvahdjukaar.moonlight.api.trades.RemoveNonDataListingListing;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public class ItemListingManager
extends RegistryAccessJsonReloadListener {
    protected static final CodecMapRegistry<ModItemListing> REGISTRY = MapRegistry.ofCodec();
    private static final Map<EntityType<?>, Int2ObjectArrayMap<List<ModItemListing>>> SPECIAL_CUSTOM_TRADES = new HashMap();
    private static final Map<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>> CUSTOM_TRADES = new HashMap<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>>();
    private static final Map<EntityType<?>, Int2ObjectArrayMap<ModItemListing[]>> oldSpecialTrades = new HashMap();
    private static final Map<VillagerProfession, Int2ObjectArrayMap<ModItemListing[]>> oldTrades = new HashMap<VillagerProfession, Int2ObjectArrayMap<ModItemListing[]>>();
    private static int count = 0;

    public ItemListingManager() {
        super(new Gson(), "moonlight/villager_trade");
    }

    @Override
    public void parse(Map<ResourceLocation, JsonElement> jsons, RegistryAccess registryAccess) {
        this.mergeProfessionAndSpecial(false);
        count = 0;
        CUSTOM_TRADES.clear();
        SPECIAL_CUSTOM_TRADES.clear();
        DynamicOps ops = ForgeHelper.addConditionOps(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess));
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            JsonElement json = e.getValue();
            ResourceLocation id = e.getKey();
            if (!id.getPath().contains("/")) continue;
            this.parseAndAddTrade(json, id, ops);
        }
        this.mergeProfessionAndSpecial(true);
        if (count != 0) {
            Moonlight.LOGGER.info("Applied {} data villager trades", (Object)count);
        }
    }

    private void parseAndAddTrade(JsonElement json, ResourceLocation id, DynamicOps<JsonElement> ops) {
        ResourceLocation targetId = id.withPath(p -> p.substring(0, p.lastIndexOf(47)));
        Optional profession = BuiltInRegistries.VILLAGER_PROFESSION.getOptional(targetId);
        if (profession.isPresent()) {
            ModItemListing trade = ItemListingManager.parseOrThrow(json, id, ops);
            if (!(trade instanceof NoOpListing) && !(trade instanceof RemoveNonDataListingListing)) {
                ((List)CUSTOM_TRADES.computeIfAbsent((VillagerProfession)profession.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
            }
            return;
        }
        Optional entityType = BuiltInRegistries.ENTITY_TYPE.getOptional(targetId);
        if (entityType.isPresent()) {
            ModItemListing trade = ItemListingManager.parseOrThrow(json, id, ops);
            if (!(trade instanceof NoOpListing)) {
                ((List)SPECIAL_CUSTOM_TRADES.computeIfAbsent((EntityType)entityType.get(), t -> new Int2ObjectArrayMap()).computeIfAbsent(trade.getLevel(), a -> new ArrayList())).add(trade);
            }
        } else {
            Moonlight.LOGGER.warn("Unknown villager type: {}", (Object)targetId);
        }
    }

    private void mergeAll(Int2ObjectMap<VillagerTrades.ItemListing[]> originalValues, Int2ObjectArrayMap<List<ModItemListing>> newValues, boolean add) {
        for (Int2ObjectMap.Entry e : newValues.int2ObjectEntrySet()) {
            int level = e.getIntKey();
            VillagerTrades.ItemListing[] elements = (VillagerTrades.ItemListing[])originalValues.get(level);
            ArrayList original = new ArrayList(elements == null ? List.of() : List.of(elements));
            List value = (List)e.getValue();
            if (add) {
                original.addAll(value);
                count += value.size();
            } else {
                original.removeAll(value);
            }
            originalValues.put(level, (Object)((VillagerTrades.ItemListing[])original.toArray(VillagerTrades.ItemListing[]::new)));
        }
    }

    private void mergeProfessionAndSpecial(boolean add) {
        for (Map.Entry<VillagerProfession, Int2ObjectArrayMap<List<ModItemListing>>> p : CUSTOM_TRADES.entrySet()) {
            VillagerProfession profession = p.getKey();
            Int2ObjectMap map = VillagerTrades.TRADES.computeIfAbsent(profession, k -> new Int2ObjectArrayMap());
            Int2ObjectArrayMap<List<ModItemListing>> value = p.getValue();
            this.mergeAll((Int2ObjectMap<VillagerTrades.ItemListing[]>)map, value, add);
        }
        Int2ObjectArrayMap<List<ModItemListing>> wanderingStuff = SPECIAL_CUSTOM_TRADES.get(EntityType.WANDERING_TRADER);
        if (wanderingStuff != null) {
            this.mergeAll((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.WANDERING_TRADER_TRADES, wanderingStuff, add);
        }
    }

    private static ModItemListing parseOrThrow(JsonElement j, ResourceLocation id, DynamicOps<JsonElement> ops) {
        return (ModItemListing)((Pair)ModItemListing.CODEC.decode(ops, (Object)j).getOrThrow(errorMsg -> new JsonParseException("Failed to parse custom trade with id " + String.valueOf(id) + " - error: " + errorMsg))).getFirst();
    }

    public static List<? extends VillagerTrades.ItemListing> getVillagerListings(VillagerProfession profession, int level) {
        VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])((Int2ObjectMap)VillagerTrades.TRADES.get(profession)).get(level);
        if (array == null) {
            return List.of();
        }
        return Arrays.stream(array).toList();
    }

    public static List<? extends VillagerTrades.ItemListing> getSpecialListings(EntityType<?> entityType, int level) {
        if (entityType == EntityType.WANDERING_TRADER) {
            VillagerTrades.ItemListing[] array = (VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.get(level);
            if (array == null) {
                return List.of();
            }
            return Arrays.stream(array).toList();
        }
        Int2ObjectArrayMap<List<ModItemListing>> special = SPECIAL_CUSTOM_TRADES.get(entityType);
        if (special == null) {
            return List.of();
        }
        return (List)special.getOrDefault(level, List.of());
    }

    public static void registerSerializer(ResourceLocation id, MapCodec<? extends ModItemListing> trade) {
        REGISTRY.register(id, trade);
    }

    public static void registerSimple(ResourceLocation id, VillagerTrades.ItemListing instance, int level) {
        SpecialListing specialListing = new SpecialListing(instance, level);
        ItemListingManager.registerSerializer(id, specialListing.getCodec());
    }

    static {
        REGISTRY.register(ResourceLocation.parse((String)"simple"), SimpleItemListing.CODEC);
        REGISTRY.register(ResourceLocation.parse((String)"remove_all_non_data"), RemoveNonDataListingListing.CODEC);
        REGISTRY.register(ResourceLocation.parse((String)"no_op"), NoOpListing.CODEC);
    }

    private static class SpecialListing
    implements ModItemListing {
        private final MapCodec<ModItemListing> codec = MapCodec.unit((Object)this);
        private final VillagerTrades.ItemListing listing;
        private final int level;

        public SpecialListing(VillagerTrades.ItemListing listing, int level) {
            this.listing = listing;
            this.level = level;
        }

        @Override
        public MapCodec<? extends ModItemListing> getCodec() {
            return this.codec;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, RandomSource random) {
            return this.listing.getOffer(trader, random);
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }
}

