/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static final Codec<WoodType> CODEC = ResourceLocation.CODEC.flatXmap(r -> {
        WoodType w = WoodTypeRegistry.getValue(r);
        if (w == null) {
            return DataResult.error(() -> "No such wood type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final Block planks;
    public final Block log;
    private final Supplier<net.minecraft.world.level.block.state.properties.WoodType> vanillaType = Suppliers.memoize(this::detectVanillaWood);

    @Nullable
    private net.minecraft.world.level.block.state.properties.WoodType detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof CeilingHangingSignBlock) {
            CeilingHangingSignBlock c = (CeilingHangingSignBlock)object;
            return c.type();
        }
        object = this.getChild("sign");
        if (object instanceof SignBlock) {
            SignBlock f = (SignBlock)object;
            return f.type();
        }
        String i = this.id.getNamespace().equals("minecraft") ? this.id.getPath() : this.id.toString();
        Stream values = net.minecraft.world.level.block.state.properties.WoodType.values();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = values.filter(v -> v.name().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Nullable
    protected Block findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            Block stripped;
            Block b = this.getBlockOfThis(v);
            if (v == null || (stripped = (Block)AxeItem.STRIPPABLES.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected Block findLogRelatedBlock(String prefix, String ... possibleNames) {
        for (String n : possibleNames) {
            Block b = this.findWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findWithPrefix(String prefix, String postfix) {
        Optional o;
        Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
        ResourceLocation id = this.getId();
        String logN = Utils.getID(this.log).getPath();
        String path = id.getPath();
        if ((this.id.getNamespace().equals("tfc") || this.id.getNamespace().equals("afc")) && (o = BuiltInRegistries.BLOCK.getOptional(id.withPath("wood/" + (String)prefix_ + postfix + "/" + path))).isPresent()) {
            return (Block)o.get();
        }
        HashSet targets = new HashSet();
        Collections.addAll(targets, id.withPath(path + "_" + (String)prefix_ + postfix), id.withPath((String)prefix_ + path + "_" + postfix), id.withPath(logN + "_" + (String)prefix_ + postfix), id.withPath((String)prefix_ + logN + "_" + postfix));
        Block found = null;
        for (ResourceLocation r : targets) {
            if (!BuiltInRegistries.BLOCK.containsKey(r)) continue;
            found = (Block)BuiltInRegistries.BLOCK.get(r);
            break;
        }
        return found;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType.get();
    }

    @NotNull
    public net.minecraft.world.level.block.state.properties.WoodType toVanillaOrOak() {
        net.minecraft.world.level.block.state.properties.WoodType v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return net.minecraft.world.level.block.state.properties.WoodType.OAK;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.defaultBlockState().ignitedByLava();
    }

    public MapColor getColor() {
        return this.planks.defaultMapColor();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", BuiltInRegistries.BLOCK));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae"));
        this.addChild("slab", this.findRelatedEntry("slab", BuiltInRegistries.BLOCK));
        this.addChild("stairs", this.findRelatedEntry("stairs", BuiltInRegistries.BLOCK));
        this.addChild("fence", this.findRelatedEntry("fence", BuiltInRegistries.BLOCK));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", BuiltInRegistries.BLOCK));
        this.addChild("door", this.findRelatedEntry("door", BuiltInRegistries.BLOCK));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", BuiltInRegistries.BLOCK));
        this.addChild("button", this.findRelatedEntry("button", BuiltInRegistries.BLOCK));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", BuiltInRegistries.BLOCK));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", BuiltInRegistries.BLOCK));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", BuiltInRegistries.BLOCK));
        this.addChild("sign", this.findRelatedEntry("sign", BuiltInRegistries.BLOCK));
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", BuiltInRegistries.ITEM));
        this.addChild("chest_boat", this.findRelatedEntry("chest_boat", BuiltInRegistries.ITEM));
        this.addChild("sapling", this.findRelatedEntry("sapling", BuiltInRegistries.ITEM));
        this.addChild("stick", this.findRelatedEntry("twig", BuiltInRegistries.BLOCK));
    }

    @Override
    @Nullable
    protected <V> V findRelatedEntry(String before, String after, Registry<V> reg) {
        if (!((String)after).isEmpty()) {
            after = "_" + (String)after;
        }
        ResourceLocation[] targets = new ResourceLocation[]{this.id.withPath(this.id.getPath() + "_" + before + (String)after), this.id.withPath(before + "_" + this.id.getPath() + (String)after), this.id.withPath(this.id.getPath() + "_planks_" + before + (String)after), this.id.withPath("wood/planks/" + this.id.getPath() + "_" + before), this.id.withPath("wood/" + before + (String)after + "/" + this.id.getPath())};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.containsKey(r)) continue;
            found = reg.get(r);
            break;
        }
        return (V)found;
    }

    public BlockBehaviour.Properties copyProperties() {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.of();
        p.mapColor(this.getColor());
        if (this.canBurn()) {
            p.ignitedByLava();
        }
        p.sound(this.getSound());
        return p;
    }

    public static class Finder
    implements BlockType.SetFinder<WoodType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(ResourceLocation.fromNamespaceAndPath((String)modId, (String)woodTypeName), ResourceLocation.fromNamespaceAndPath((String)modId, (String)planksName), ResourceLocation.fromNamespaceAndPath((String)modId, (String)logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)BuiltInRegistries.BLOCK.get(planksName), () -> (Block)BuiltInRegistries.BLOCK.get(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, this.id.withPath(childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.getNamespace())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getDefaultKey());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> {
                            Block obj = (Block)BuiltInRegistries.BLOCK.get(value);
                            if (obj != null && obj != d) {
                                w.addChild((String)key, obj);
                            }
                        });
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

