/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class LeavesType
extends BlockType {
    public static final Codec<LeavesType> CODEC = ResourceLocation.CODEC.flatXmap(r -> {
        LeavesType w = LeavesTypeRegistry.getValue(r);
        if (w == null) {
            return DataResult.error(() -> "No such leaves type: " + String.valueOf(r));
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final Block leaves;
    private final Supplier<WoodType> woodType;

    protected LeavesType(ResourceLocation id, Block leaves) {
        this(id, leaves, (Supplier<WoodType>)Suppliers.memoize(() -> Objects.requireNonNullElse(WoodTypeRegistry.getValue(id), WoodTypeRegistry.OAK_TYPE)));
    }

    protected LeavesType(ResourceLocation id, Block leaves, Supplier<WoodType> woodType) {
        super(id);
        this.leaves = leaves;
        this.woodType = woodType;
    }

    public WoodType getWoodType() {
        return this.woodType.get();
    }

    @Override
    public ItemLike mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("leaves", this.leaves);
        this.woodType.get();
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("sapling", this.findRelatedEntry("sapling", BuiltInRegistries.ITEM));
    }

    public static class Finder
    implements BlockType.SetFinder<LeavesType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> leavesFinder;
        private final Supplier<WoodType> woodFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> leaves, @Nullable Supplier<WoodType> wood) {
            this.id = id;
            this.leavesFinder = leaves;
            this.woodFinder = wood;
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(ResourceLocation.fromNamespaceAndPath((String)modId, (String)leavesTypeName), () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)leavesName)), null);
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName, String woodTypeName) {
            return new Finder(ResourceLocation.fromNamespaceAndPath((String)modId, (String)leavesTypeName), () -> (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)modId, (String)leavesName)), () -> (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)woodTypeName)));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, this.id.withPath(childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatHelper.isModLoaded(this.id.getNamespace())) {
                try {
                    Block leaves = this.leavesFinder.get();
                    Block d = (Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.BLOCK.getDefaultKey());
                    if (leaves != d && leaves != null) {
                        if (this.woodFinder == null) {
                            LeavesType l = new LeavesType(this.id, leaves);
                            this.childNames.forEach((key, value) -> l.addChild((String)key, BuiltInRegistries.BLOCK.get(value)));
                            return Optional.of(l);
                        }
                        LeavesType l = new LeavesType(this.id, leaves, this.woodFinder);
                        this.childNames.forEach((key, value) -> l.addChild((String)key, BuiltInRegistries.BLOCK.get(value)));
                        return Optional.of(l);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

