/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.DataSet;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.IDataEntry;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.KMeans;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;

public final class SpriteUtils {
    public static NativeImage readImage(ResourceManager manager, ResourceLocation resourceLocation) throws IOException, NoSuchElementException {
        NativeImage nativeImage;
        block8: {
            InputStream res = ((Resource)manager.getResource(resourceLocation).get()).open();
            try {
                nativeImage = NativeImage.read((InputStream)res);
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            res.close();
        }
        return nativeImage;
    }

    public static void forEachPixel(NativeImage image, BiConsumer<Integer, Integer> function) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                function.accept(x, y);
            }
        }
    }

    public static void grayscaleImage(NativeImage image) {
        SpriteUtils.forEachPixel(image, (x, y) -> image.setPixelRGBA(x.intValue(), y.intValue(), new RGBColor(image.getPixelRGBA(x.intValue(), y.intValue())).asHCL().withChroma(0.0f).asRGB().toInt()));
    }

    public static RGBColor averageColor(NativeImage image) {
        Palette p = Palette.fromImage(TextureImage.of(image, null), null, 0.0f);
        if (p.size() == 0) {
            return new RGBColor(-1);
        }
        DataSet<DataSet.ColorPoint> data = DataSet.fromPalette(p);
        KMeans.kMeans(data, 1);
        return data.getLastCentroids().get(0).cast().getColor().rgb();
    }

    public static List<Palette> extrapolateSignBlockPalette(TextureImage planksTexture) {
        ArrayList<Palette> newPalettes = new ArrayList<Palette>();
        List<Palette> oakPalettes = Palette.fromAnimatedImage(planksTexture, null, 0.0033333334f);
        for (Palette palette : oakPalettes) {
            SpriteUtils.extrapolateSignBlockPalette(palette);
            newPalettes.add(palette);
        }
        return newPalettes;
    }

    public static void extrapolateSignBlockPalette(Palette palette) {
        int size = palette.size();
        if (size == 7) {
            PaletteColor color = palette.get(size - 3);
            HSVColor hsv = color.rgb().asHSV();
            float satIncrease = 1.0638298f;
            float brightnessIncrease = 1.0638298f;
            HSVColor newCol = new HSVColor(hsv.hue(), Mth.clamp((float)(hsv.saturation() * satIncrease), (float)0.0f, (float)1.0f), Mth.clamp((float)(hsv.value() * brightnessIncrease), (float)0.0f, (float)1.0f), hsv.alpha());
            PaletteColor newP = new PaletteColor(newCol);
            newP.setOccurrence(color.getOccurrence());
            palette.set(size - 1, newP);
            palette.remove(size - 2);
        }
    }

    public static Palette extrapolateWoodItemPalette(TextureImage planksTexture) {
        Palette palette = Palette.fromAnimatedImage(planksTexture, null).get(0);
        SpriteUtils.extrapolateWoodItemPalette(palette);
        return palette;
    }

    public static void extrapolateWoodItemPalette(Palette palette) {
        PaletteColor color = palette.get(0);
        HSVColor hsv = color.rgb().asHSV();
        float satMult = 1.11f;
        float brightnessMult = 0.94f;
        HSVColor newCol = new HSVColor(hsv.hue(), Mth.clamp((float)(hsv.saturation() * satMult), (float)0.0f, (float)1.0f), Mth.clamp((float)(hsv.value() * brightnessMult), (float)0.0f, (float)1.0f), hsv.alpha());
        PaletteColor newP = new PaletteColor(newCol);
        newP.setOccurrence(color.getOccurrence());
        palette.set(0, newP);
    }

    @Deprecated
    public static float getLuminance(int r, int g, int b) {
        return 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
    }

    public static void reduceColors(NativeImage image, IntUnaryOperator sizeFn) {
        Palette p = Palette.fromImage(TextureImage.of(image, null), null, 0.0f);
        if (p.size() == 0) {
            return;
        }
        DataSet<DataSet.ColorPoint> data = DataSet.fromPalette(p);
        int size = sizeFn.applyAsInt(p.size());
        if (size >= p.size()) {
            return;
        }
        KMeans.kMeans(data, size);
        HashMap<Integer, Integer> colorToColorMap = new HashMap<Integer, Integer>();
        for (IDataEntry<DataSet.ColorPoint> c : data.getColorPoints()) {
            IDataEntry<DataSet.ColorPoint> centroid = data.getLastCentroids().get(c.getClusterNo());
            colorToColorMap.put(c.cast().getColor().value(), centroid.cast().getColor().value());
        }
        SpriteUtils.forEachPixel(image, (x, y) -> {
            int i = image.getPixelRGBA(x.intValue(), y.intValue());
            if (colorToColorMap.containsKey(i)) {
                image.setPixelRGBA(x.intValue(), y.intValue(), ((Integer)colorToColorMap.get(i)).intValue());
            }
        });
    }

    public static void mergeSimilarColors(NativeImage image, float tolerance) {
        TextureImage texture = TextureImage.of(image, null);
        Palette originalPalette = Palette.fromImage(texture, null, 0.0f);
        Palette targetPalette = originalPalette.copy();
        targetPalette.updateTolerance(tolerance);
        originalPalette.removeAll(targetPalette);
        HashMap<Integer, Integer> removedColors = new HashMap<Integer, Integer>();
        for (PaletteColor i : originalPalette) {
            PaletteColor replacement = targetPalette.getColorClosestTo(i);
            removedColors.put(i.value(), replacement.value());
        }
        SpriteUtils.forEachPixel(image, (x, y) -> {
            int i = image.getPixelRGBA(x.intValue(), y.intValue());
            Integer replacement = (Integer)removedColors.get(i);
            if (replacement != null) {
                image.setPixelRGBA(x.intValue(), y.intValue(), replacement.intValue());
            }
        });
    }

    public static List<Integer> parsePaletteStrip(ResourceManager manager, ResourceLocation fullTexturePath, int expectColors) {
        ArrayList<Integer> arrayList;
        block9: {
            NativeImage image = SpriteUtils.readImage(manager, fullTexturePath);
            try {
                ArrayList<Integer> list = new ArrayList<Integer>();
                SpriteUtils.forEachPixel(image, (x, y) -> {
                    int i = image.getPixelRGBA(x.intValue(), y.intValue());
                    if (i == 0 || list.size() >= expectColors) {
                        return;
                    }
                    list.add(i);
                });
                if (list.size() < expectColors) {
                    throw new RuntimeException("Image at " + String.valueOf(fullTexturePath) + " has too few colors! Expected at least " + expectColors + " and got " + list.size());
                }
                arrayList = list;
                if (image == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchElementException e) {
                    throw new RuntimeException("Failed to find image at location " + String.valueOf(fullTexturePath), e);
                }
            }
            image.close();
        }
        return arrayList;
    }

    public static TextureImage savePaletteStrip(ResourceManager manager, List<Integer> colors) {
        TextureImage image = TextureImage.createNew(16, 16, null);
        try {
            Iterator<Integer> it = colors.iterator();
            image.forEachFramePixel((x, y, f) -> {
                if (it.hasNext()) {
                    image.getImage().setPixelRGBA(x.intValue(), y.intValue(), ((Integer)it.next()).intValue());
                }
            });
            TextureImage textureImage = image;
            if (image != null) {
                image.close();
            }
            return textureImage;
        }
        catch (Throwable throwable) {
            try {
                if (image != null) {
                    try {
                        image.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create palette strip");
            }
        }
    }
}

