/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ResourceConditionsBridge {
    private static final Codec<ICondition> REMAPPING_CODEC = ResourceConditionsBridge.byNameCodecRemap(NeoForgeRegistries.CONDITION_SERIALIZERS, "fabric", "neoforge").dispatch("type", ICondition::codec, Function.identity());
    private static final Codec<List<ICondition>> LIST_CODEC = Utils.lenientListCodec(REMAPPING_CODEC);
    private static final Codec<ICondition> SINGLE_OR_LIST = Codec.withAlternative(REMAPPING_CODEC, LIST_CODEC, AndCondition::new);

    private static <T> Codec<T> byNameCodecRemap(Registry<T> registry, String from, String to) {
        return ResourceLocation.CODEC.xmap(r -> ResourceLocation.fromNamespaceAndPath((String)r.getNamespace().replace(from, to), (String)r.getPath()), Function.identity()).comapFlatMap(arg -> registry.getOptional(arg).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.key()) + ": " + String.valueOf(arg))), arg_0 -> registry.getKey(arg_0));
    }

    public static boolean matchesForgeConditions(JsonObject obj, ICondition.IContext context, String conditionKey) {
        JsonElement newObj;
        DataResult c;
        JsonElement conditionElement = obj.get(conditionKey);
        if (conditionElement != null && (c = SINGLE_OR_LIST.parse((DynamicOps)JsonOps.INSTANCE, (Object)(newObj = ResourceConditionsBridge.replaceKeyInJsonRecursive(conditionElement, "condition", "type")))).result().isPresent()) {
            return ((ICondition)c.getOrThrow()).test(context);
        }
        return true;
    }

    public static void init() {
        try {
            RegHelper.register(ResourceLocation.parse((String)"neoforge:all_mods_loaded"), () -> AllModsLoadedResourceCondition.CODEC, NeoForgeRegistries.Keys.CONDITION_CODECS);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to register neoforge conditions", (Throwable)e);
        }
    }

    private static JsonElement replaceKeyInJsonRecursive(JsonElement json, String from, String to) {
        if (json.isJsonObject()) {
            JsonObject newObj = new JsonObject();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                String key = ((String)entry.getKey()).equals(from) ? to : (String)entry.getKey();
                newObj.add(key, ResourceConditionsBridge.replaceKeyInJsonRecursive((JsonElement)entry.getValue(), from, to));
            }
            return newObj;
        }
        if (json.isJsonArray()) {
            JsonArray newArray = new JsonArray();
            for (JsonElement element : json.getAsJsonArray()) {
                newArray.add(ResourceConditionsBridge.replaceKeyInJsonRecursive(element, from, to));
            }
            return newArray;
        }
        return json;
    }

    public record AllModsLoadedResourceCondition(List<String> modIds) implements ICondition
    {
        public static final MapCodec<AllModsLoadedResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("values").forGetter(AllModsLoadedResourceCondition::modIds)).apply((Applicative)instance, AllModsLoadedResourceCondition::new));

        public boolean test(ICondition.IContext iContext) {
            for (String modId : this.modIds) {
                if (PlatHelper.isModLoaded(modId)) continue;
                return false;
            }
            return true;
        }

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }
    }
}

