/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.neoforge;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.ModFlowingFluid;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge.OptionalRecipeCondition;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

public class RegHelperImpl {
    private static final Map<ResourceKey<? extends Registry<?>>, Map<String, DeferredRegister<?>>> REGISTRIES = new ConcurrentHashMap();

    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, Registry<T> reg) {
        return RegHelperImpl.register(name, supplier, reg.key());
    }

    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> regKey) {
        if (supplier == null) {
            throw new IllegalArgumentException("Registry entry Supplier for " + String.valueOf(name) + " can't be null");
        }
        if (name.getNamespace().equals("minecraft")) {
            throw new IllegalArgumentException("Registering under minecraft namespace is not supported");
        }
        Map m = REGISTRIES.computeIfAbsent(regKey, h -> new ConcurrentHashMap());
        String modId = name.getNamespace();
        DeferredRegister registry = m.computeIfAbsent(modId, c -> {
            Moonlight.addDependent(modId);
            DeferredRegister r = DeferredRegister.create((ResourceKey)regKey, (String)modId);
            IEventBus bus = RegHelperImpl.getModEventBus(modId);
            r.register(bus);
            return r;
        });
        DeferredHolder register = registry.register(name.getPath(), () -> {
            Object obj = supplier.get();
            if (regKey.equals(Registries.FLUID) && obj instanceof ModFlowingFluid) {
                ModFlowingFluid fluid = (ModFlowingFluid)((Object)((Object)obj));
                RegHelperImpl.register(name, () -> ((ModFlowingFluid)fluid).getFluidType(), NeoForgeRegistries.Keys.FLUID_TYPES);
            }
            return obj;
        });
        return new EntryWrapper(register);
    }

    private static IEventBus getModEventBus(String modId) {
        IEventBus bus;
        ModList modList = ModList.get();
        if (modId.equals("fabric") || modId.equals("neoforge")) {
            modId = "moonlight";
        }
        Preconditions.checkNotNull((Object)modList, (Object)"ModList was null. This means that some mod registry classes were loaded way too early, likely by mixins");
        ModContainer cont = (ModContainer)modList.getModContainerById(modId).get();
        if (!(cont instanceof FMLModContainer)) {
            Moonlight.LOGGER.warn("Failed to get mod container for mod {}", (Object)modId);
            bus = MoonlightForge.getCurrentBus();
        } else {
            FMLModContainer container = (FMLModContainer)cont;
            bus = container.getEventBus();
        }
        return bus;
    }

    public static <T, E extends T> RegSupplier<E> registerAsync(ResourceLocation name, Supplier<E> supplier, ResourceKey<? extends Registry<T>> reg) {
        return RegHelperImpl.register(name, supplier, reg);
    }

    public static <T> void registerInBatch(Registry<T> reg, Consumer<Registrator<T>> eventListener) {
        Consumer<RegisterEvent> eventConsumer = event -> {
            if (event.getRegistry() == reg) {
                eventListener.accept((r, o) -> Registry.register((Registry)reg, (ResourceLocation)r, (Object)o));
            }
        };
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static <C extends AbstractContainerMenu> RegSupplier<MenuType<C>> registerMenuType(ResourceLocation name, TriFunction<Integer, Inventory, FriendlyByteBuf, C> containerFactory) {
        return RegHelperImpl.register(name, () -> IMenuTypeExtension.create(containerFactory::apply), Registries.MENU);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, int updateInterval) {
        return RegHelperImpl.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).build(name.toString()), Registries.ENTITY_TYPE);
    }

    public static <T extends Fluid> RegSupplier<T> registerFluid(ResourceLocation name, Supplier<T> fluid) {
        RegSupplier<T> f = RegHelperImpl.register(name, fluid, Registries.FLUID);
        return f;
    }

    public static <T extends CraftingRecipe> RegSupplier<RecipeSerializer<T>> registerSpecialRecipe(ResourceLocation name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
        return RegHelper.registerRecipeSerializer(name, () -> new SimpleCraftingRecipeSerializer(factory));
    }

    public static RegSupplier<CreativeModeTab> registerCreativeModeTab(ResourceLocation name, boolean hasSearchBar, List<ResourceLocation> afterEntries, List<ResourceLocation> beforeEntries, Consumer<CreativeModeTab.Builder> configurator) {
        return RegHelperImpl.register(name, () -> {
            CreativeModeTab.Builder b = CreativeModeTab.builder();
            configurator.accept(b);
            if (!beforeEntries.isEmpty()) {
                b.withTabsBefore((ResourceLocation[])beforeEntries.toArray(ResourceLocation[]::new));
            }
            if (!afterEntries.isEmpty()) {
                b.withTabsBefore((ResourceLocation[])afterEntries.toArray(ResourceLocation[]::new));
            }
            if (hasSearchBar) {
                b.withSearchBar();
            }
            return b.build();
        }, Registries.CREATIVE_MODE_TAB);
    }

    public static void registerItemBurnTime(Item item, int burnTime) {
    }

    public static void registerBlockFlammability(Block item, int fireSpread, int flammability) {
        ((FireBlock)Blocks.FIRE).setFlammable(item, fireSpread, flammability);
    }

    public static void addAttributeRegistration(Consumer<RegHelper.AttributeEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<EntityAttributeCreationEvent> eventConsumer = event -> eventListener.accept((e, b) -> event.put(e, b.build()));
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void addCommandRegistration(RegHelper.CommandRegistration eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterCommandsEvent> eventConsumer = event -> eventListener.accept((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        NeoForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void addSpawnPlacementsRegistration(Consumer<RegHelper.SpawnPlacementEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<RegisterSpawnPlacementsEvent> eventConsumer = event -> {
            PlacementEventImpl spawnPlacementEvent = new PlacementEventImpl((RegisterSpawnPlacementsEvent)event);
            eventListener.accept(spawnPlacementEvent);
        };
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }

    public static void registerSimpleRecipeCondition(ResourceLocation id, Predicate<String> predicate) {
        RegHelperImpl.register(id, () -> OptionalRecipeCondition.createCodec(id, predicate), NeoForgeRegistries.Keys.CONDITION_CODECS);
    }

    public static void addItemsToTabsRegistration(Consumer<RegHelper.ItemToTabEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<BuildCreativeModeTabContentsEvent> eventConsumer = event -> {
            ItemToTabEventImpl itemToTabEvent = new ItemToTabEventImpl((BuildCreativeModeTabContentsEvent)event);
            eventListener.accept(itemToTabEvent);
        };
        MoonlightForge.getCurrentBus().addListener(EventPriority.LOW, eventConsumer);
    }

    public static void addLootTableInjects(Consumer<RegHelper.LootInjectEvent> eventListener) {
        Moonlight.assertInitPhase();
        Consumer<LootTableLoadEvent> eventConsumer = event -> eventListener.accept(new RegHelper.LootInjectEvent((LootTableLoadEvent)event){
            final /* synthetic */ LootTableLoadEvent val$event;
            {
                this.val$event = lootTableLoadEvent;
            }

            @Override
            public ResourceLocation getTable() {
                return this.val$event.getName();
            }

            @Override
            public void addTableReference(ResourceLocation targetId) {
                LootPool pool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)targetId))).build();
                this.val$event.getTable().addPool(pool);
            }
        });
        NeoForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static void registerFireworkRecipe(FireworkExplosion.Shape shape, Item ingredient) {
        FireworkStarRecipe.SHAPE_BY_ITEM = new HashMap(FireworkStarRecipe.SHAPE_BY_ITEM);
        FireworkStarRecipe.SHAPE_BY_ITEM.put(ingredient, shape);
        FireworkStarRecipe.SHAPE_INGREDIENT = CompoundIngredient.of((Ingredient[])new Ingredient[]{FireworkStarRecipe.SHAPE_INGREDIENT, Ingredient.of((ItemLike[])new ItemLike[]{ingredient})});
    }

    public static void startRegisteringFor(Object bus) {
        if (!(bus instanceof IEventBus)) {
            throw new IllegalArgumentException("Invalid bus type. Must be of IEventBus type: " + String.valueOf(bus));
        }
        IEventBus b = (IEventBus)bus;
        MoonlightForge.startRegistering(b);
    }

    public record EntryWrapper<T>(DeferredHolder<T, ? extends T> registryObject) implements RegSupplier<T>
    {
        @Override
        public T get() {
            return (T)this.registryObject.get();
        }

        @Override
        public ResourceLocation getId() {
            return this.registryObject.getId();
        }

        @Override
        public ResourceKey<T> getKey() {
            return this.registryObject.getKey();
        }

        @Override
        public Holder<T> getHolder() {
            return this.registryObject;
        }
    }

    private record ItemToTabEventImpl(BuildCreativeModeTabContentsEvent event) implements RegHelper.ItemToTabEvent
    {
        public void removeItems(ResourceKey<CreativeModeTab> tab, Predicate<ItemStack> target) {
            this.event.getParentEntries().removeIf(target);
            this.event.getSearchEntries().removeIf(target);
        }

        @Override
        public void addItems(ResourceKey<CreativeModeTab> tab, @Nullable Predicate<ItemStack> target, boolean after, List<ItemStack> items) {
            if (this.event.getTabKey() != tab) {
                return;
            }
            if (target != null) {
                if (after) {
                    ItemStack last = this.findLast(this.event, target);
                    if (!last.isEmpty()) {
                        for (int j = items.size(); j > 0; --j) {
                            this.event.insertAfter(last, items.get(j - 1), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        }
                        return;
                    }
                    Moonlight.logIfInDev("Failed to find target item before for items: " + String.valueOf(items));
                } else {
                    ItemStack first = this.findFirst(this.event, target);
                    if (!first.isEmpty()) {
                        for (ItemStack s : items) {
                            this.event.insertBefore(first, s, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                        }
                        return;
                    }
                    Moonlight.logIfInDev("Failed to find target item after for items: " + String.valueOf(items));
                }
            }
            this.event.acceptAll(items);
        }

        private ItemStack findFirst(BuildCreativeModeTabContentsEvent event, Predicate<ItemStack> target) {
            for (ItemStack s : event.getParentEntries()) {
                if (!target.test(s)) continue;
                return s;
            }
            return ItemStack.EMPTY;
        }

        private ItemStack findLast(BuildCreativeModeTabContentsEvent event, Predicate<ItemStack> target) {
            boolean foundOne = false;
            ItemStack previous = ItemStack.EMPTY;
            for (ItemStack s : event.getParentEntries()) {
                if (target.test(s)) {
                    foundOne = true;
                    previous = s;
                    continue;
                }
                if (!foundOne) continue;
                return previous;
            }
            return previous;
        }
    }

    record PlacementEventImpl(RegisterSpawnPlacementsEvent event) implements RegHelper.SpawnPlacementEvent
    {
        @Override
        public <T extends Mob> void register(EntityType<T> entityType, SpawnPlacementType decoratorType, Heightmap.Types heightMapType, SpawnPlacements.SpawnPredicate<T> decoratorPredicate) {
            this.event.register(entityType, decoratorType, heightMapType, decoratorPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
        }
    }
}

