/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc.fake_level;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProgressListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.timers.TimerCallbacks;
import net.minecraft.world.level.timers.TimerQueue;
import org.jetbrains.annotations.Nullable;

public class FakeServerLevel
extends ServerLevel {
    private final ServerScoreboard scoreboard;

    public FakeServerLevel(String name, ServerLevel original) {
        super(original.getServer(), (Executor)Util.backgroundExecutor(), original.getServer().storageSource, (ServerLevelData)new ReadOlyServerLevelData(name, original.serverLevelData), ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)name)), new LevelStem(original.dimensionTypeRegistration(), original.getChunkSource().getGenerator()), (ChunkProgressListener)new DummyProgressListener(), false, 0L, Collections.emptyList(), false, new RandomSequences(0L));
        this.players().clear();
        this.scoreboard = new ServerScoreboard(original.getServer());
    }

    public void playSound(Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void playSound(Player player, Entity entity, SoundEvent soundEvent, SoundSource category, float volume, float pitch) {
    }

    public void playSeededSound(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Player player, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch, long seed) {
    }

    public void playSeededSound(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
    }

    public void levelEvent(Player player, int type, BlockPos pos, int data) {
    }

    public void globalLevelEvent(int id, BlockPos pos, int data) {
    }

    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress) {
    }

    public void gameEvent(Holder<GameEvent> gameEvent, BlockPos pos, GameEvent.Context context) {
    }

    public void setDefaultSpawnPos(BlockPos pos, float angle) {
    }

    protected void tickTime() {
    }

    public ServerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void save(@Nullable ProgressListener progress, boolean flush, boolean skipSave) {
    }

    @Nullable
    public BlockPos findNearestMapStructure(TagKey<Structure> structureTag, BlockPos pos, int radius, boolean skipExistingChunks) {
        return null;
    }

    public void setMapData(MapId mapId, MapItemSavedData mapData) {
        super.setMapData(mapId, mapData);
    }

    @Nullable
    public MapItemSavedData getMapData(MapId mapId) {
        return null;
    }

    public boolean setChunkForced(int chunkX, int chunkZ, boolean add) {
        return false;
    }

    public void setBlockEntity(BlockEntity blockEntity) {
    }

    public boolean setBlock(BlockPos pos, BlockState state, int flags, int recursionLeft) {
        return false;
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pos) {
        return Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    @Nullable
    public Entity getEntity(int id) {
        return null;
    }

    public void tick(BooleanSupplier hasTimeLeft) {
    }

    public static class ReadOlyServerLevelData
    implements ServerLevelData {
        public final String name;
        public final ServerLevelData wrapped;
        private final TimerQueue<MinecraftServer> timerQueue = new TimerQueue(TimerCallbacks.SERVER_CALLBACKS);

        public ReadOlyServerLevelData(String name, ServerLevelData wrapped) {
            this.name = name;
            this.wrapped = wrapped;
        }

        public String getLevelName() {
            return this.name;
        }

        public void setThundering(boolean thundering) {
        }

        public int getRainTime() {
            return this.wrapped.getRainTime();
        }

        public void setRainTime(int time) {
        }

        public void setThunderTime(int time) {
        }

        public int getThunderTime() {
            return this.wrapped.getThunderTime();
        }

        public int getClearWeatherTime() {
            return this.wrapped.getClearWeatherTime();
        }

        public void setClearWeatherTime(int time) {
        }

        public int getWanderingTraderSpawnDelay() {
            return this.wrapped.getWanderingTraderSpawnDelay();
        }

        public void setWanderingTraderSpawnDelay(int delay) {
        }

        public int getWanderingTraderSpawnChance() {
            return this.wrapped.getWanderingTraderSpawnChance();
        }

        public void setWanderingTraderSpawnChance(int chance) {
        }

        @Nullable
        public UUID getWanderingTraderId() {
            return this.wrapped.getWanderingTraderId();
        }

        public void setWanderingTraderId(UUID id) {
        }

        public GameType getGameType() {
            return this.wrapped.getGameType();
        }

        public void setWorldBorder(WorldBorder.Settings serializer) {
        }

        public WorldBorder.Settings getWorldBorder() {
            return this.wrapped.getWorldBorder();
        }

        public boolean isInitialized() {
            return this.wrapped.isInitialized();
        }

        public void setInitialized(boolean initialized) {
        }

        public boolean isAllowCommands() {
            return this.wrapped.isAllowCommands();
        }

        public void setGameType(GameType type) {
        }

        public TimerQueue<MinecraftServer> getScheduledEvents() {
            return this.timerQueue;
        }

        public void setGameTime(long time) {
        }

        public void setDayTime(long time) {
        }

        public BlockPos getSpawnPos() {
            return this.wrapped.getSpawnPos();
        }

        public float getSpawnAngle() {
            return this.wrapped.getSpawnAngle();
        }

        public long getGameTime() {
            return this.wrapped.getGameTime();
        }

        public long getDayTime() {
            return this.wrapped.getDayTime();
        }

        public boolean isThundering() {
            return this.wrapped.isThundering();
        }

        public boolean isRaining() {
            return this.wrapped.isRaining();
        }

        public void setRaining(boolean raining) {
        }

        public boolean isHardcore() {
            return this.wrapped.isHardcore();
        }

        public GameRules getGameRules() {
            return this.wrapped.getGameRules();
        }

        public Difficulty getDifficulty() {
            return this.wrapped.getDifficulty();
        }

        public boolean isDifficultyLocked() {
            return this.wrapped.isDifficultyLocked();
        }

        public void setSpawn(BlockPos spawnPoint, float spawnAngle) {
        }
    }

    public static class DummyProgressListener
    implements ChunkProgressListener {
        public void updateSpawnPos(ChunkPos center) {
        }

        public void onStatusChange(ChunkPos chunkPos, @Nullable ChunkStatus chunkStatus) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

