/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc.fake_level;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevel;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeServerLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

public class FakeLevelManager {
    protected static final Map<String, Level> INSTANCES = new Object2ObjectArrayMap();

    @ApiStatus.Internal
    @VisibleForTesting
    public static void invalidateAll() {
        INSTANCES.clear();
    }

    public static void invalidate(String name) {
        INSTANCES.remove(name);
    }

    public static FakeLevel getDefaultClient(Level original) {
        return FakeLevelManager.getClient("dummy_world", original, FakeLevel::new);
    }

    public static <T extends FakeLevel> T getClient(String id, Level original, BiFunction<String, RegistryAccess, FakeLevel> constructor) {
        Object finalId = id = "client_" + (String)id;
        return (T)((Object)((FakeLevel)INSTANCES.computeIfAbsent((String)id, arg_0 -> FakeLevelManager.lambda$getClient$0(constructor, (String)finalId, original, arg_0))));
    }

    public static FakeServerLevel getDefaultServer(ServerLevel original) {
        return FakeLevelManager.getServer("dummy_world", original, FakeServerLevel::new);
    }

    public static <T extends FakeServerLevel> T getServer(String id, ServerLevel original, BiFunction<String, ServerLevel, FakeServerLevel> constructor) {
        Object finalId = id = "server_" + (String)id;
        return (T)((Object)((FakeServerLevel)INSTANCES.computeIfAbsent((String)id, arg_0 -> FakeLevelManager.lambda$getServer$1(constructor, (String)finalId, original, arg_0))));
    }

    public static Level get(String id, Level original, BiFunction<String, RegistryAccess, FakeLevel> clientConstr, BiFunction<String, ServerLevel, FakeServerLevel> serverConstr) {
        if (original instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)original;
            return FakeLevelManager.getServer(id, sl, serverConstr);
        }
        return FakeLevelManager.getClient(id, original, clientConstr);
    }

    public static Level getDefault(Level original) {
        if (original instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)original;
            return FakeLevelManager.getDefaultServer(sl);
        }
        return FakeLevelManager.getDefaultClient(original);
    }

    private static /* synthetic */ Level lambda$getServer$1(BiFunction constructor, String finalId, ServerLevel original, String k) {
        return (Level)constructor.apply(finalId, original);
    }

    private static /* synthetic */ Level lambda$getClient$0(BiFunction constructor, String finalId, Level original, String k) {
        return (Level)constructor.apply(finalId, original.registryAccess());
    }

    public static interface ILevelLike {
        public Level cast();
    }
}

