/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements IdMap<T>,
Codec<T> {
    private final StreamCodec<FriendlyByteBuf, T> streamCodec = new StreamC();
    private final String name;
    private final BiMap<ResourceLocation, T> map = HashBiMap.create();
    private int nextId;
    private final Reference2IntMap<T> tToId;
    private final List<T> idToT;

    public MapRegistry(String name) {
        this.name = name;
        this.idToT = Lists.newArrayListWithExpectedSize((int)32);
        this.tToId = new Reference2IntOpenHashMap(32);
        this.tToId.defaultReturnValue(-1);
    }

    public static <B> CodecMapRegistry<B> ofCodec(String name) {
        return new CodecMapRegistry(name);
    }

    public static <B> CodecMapRegistry<B> ofCodec() {
        return new CodecMapRegistry("unnamed codec registry");
    }

    public <B extends T> T register(ResourceLocation name, B value) {
        this.map.put((Object)name, value);
        this.addMapping(value);
        return value;
    }

    public <B extends T> T register(String name, B value) {
        this.register(ResourceLocation.parse((String)name), value);
        return value;
    }

    protected void addMapping(T key) {
        int value = this.nextId;
        this.tToId.put(key, value);
        while (this.idToT.size() <= value) {
            this.idToT.add(null);
        }
        this.idToT.set(value, key);
        if (this.nextId <= value) {
            this.nextId = value + 1;
        }
    }

    @Nullable
    public T getValue(ResourceLocation name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public T getValue(String name) {
        return this.getValue(ResourceLocation.parse((String)name));
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return (ResourceLocation)this.map.inverse().get(value);
    }

    public Set<ResourceLocation> keySet() {
        return this.map.keySet();
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public Set<Map.Entry<ResourceLocation, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean containsKey(ResourceLocation name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return ResourceLocation.CODEC.decode(ops, json).flatMap(pair -> {
            ResourceLocation id = (ResourceLocation)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Could not find any entry with key '" + String.valueOf(id) + "' in registry [" + this.name + "] \n Known keys: " + String.valueOf(this.keySet())) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        ResourceLocation id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Could not find element " + String.valueOf(object) + " in registry" + this.name) : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }

    public void clear() {
        this.map.clear();
    }

    public <E> Codec<E> dispatch(Function<? super E, ? extends T> type) {
        return super.dispatch(type, c -> (MapCodec)c);
    }

    public int getId(T value) {
        return this.tToId.getInt(value);
    }

    @Nullable
    public final T byId(int id) {
        return id >= 0 && id < this.idToT.size() ? (T)this.idToT.get(id) : null;
    }

    public Iterator<T> iterator() {
        return Iterators.filter(this.idToT.iterator(), Objects::nonNull);
    }

    public boolean contains(int id) {
        return this.byId(id) != null;
    }

    public int size() {
        return this.tToId.size();
    }

    public StreamCodec<FriendlyByteBuf, T> getStreamCodec() {
        return this.streamCodec;
    }

    private class StreamC
    implements StreamCodec<FriendlyByteBuf, T> {
        private StreamC() {
        }

        public T decode(FriendlyByteBuf buffer) {
            int i = VarInt.read((ByteBuf)buffer);
            return MapRegistry.this.byId(i);
        }

        public void encode(FriendlyByteBuf buffer, T value) {
            int i = MapRegistry.this.getId(value);
            VarInt.write((ByteBuf)buffer, (int)i);
        }
    }
}

