/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MapDecorationRenderer<T extends MLMapDecoration> {
    protected final ResourceLocation textureId;

    public MapDecorationRenderer(ResourceLocation texture) {
        this.textureId = texture;
    }

    protected int getColor(T decoration) {
        return -1;
    }

    protected int getAlpha(T decoration) {
        return 255;
    }

    protected boolean hasOutline(T decoration) {
        return false;
    }

    protected boolean rendersOnFrame(T decoration) {
        return true;
    }

    public boolean render(T decoration, PoseStack matrixStack, VertexConsumer vertexBuilder, MultiBufferSource buffer, @Nullable MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        return this.render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index, true);
    }

    public boolean render(T decoration, PoseStack matrixStack, VertexConsumer vertexBuilder, MultiBufferSource buffer, @Nullable MapItemSavedData mapData, boolean isOnFrame, int light, int index, boolean rendersText) {
        if (!isOnFrame || this.rendersOnFrame(decoration)) {
            matrixStack.pushPose();
            matrixStack.translate(0.0f + (float)((MLMapDecoration)decoration).getX() / 2.0f + 64.0f, 0.0f + (float)((MLMapDecoration)decoration).getY() / 2.0f + 64.0f, -0.02f);
            matrixStack.mulPose(Axis.ZP.rotationDegrees((float)(((MLMapDecoration)decoration).getRot() * 360) / 16.0f));
            matrixStack.scale(4.0f, 4.0f, 3.0f);
            if (CompatHandler.MAP_ATLASES) {
                MapAtlasCompat.scaleDecoration(matrixStack);
            }
            this.renderDecorationSprite(matrixStack, buffer, vertexBuilder, light, index, this.getColor(decoration), this.getAlpha(decoration), this.hasOutline(decoration));
            matrixStack.popPose();
            if (((MLMapDecoration)decoration).getDisplayName() != null && rendersText) {
                this.renderName(decoration, matrixStack, buffer, light);
            }
            return true;
        }
        return false;
    }

    public void renderDecorationSprite(PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer vertexBuilder, int light, int index, int color, int alpha, boolean outline) {
        int b = FastColor.ARGB32.blue((int)color);
        int g = FastColor.ARGB32.green((int)color);
        int r = FastColor.ARGB32.red((int)color);
        RenderSystem.enableDepthTest();
        TextureAtlasSprite sprite = Minecraft.getInstance().getMapDecorationTextures().getSprite(this.textureId);
        if (alpha != 0) {
            if (outline) {
                int tint = PlatHelper.getPlatform().isForge() ? 255 : 0;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexConsumer vb2 = buffer.getBuffer(RenderUtil.getColoredTextureRenderType(MapDecorationClientManager.LOCATION_MAP_MARKERS));
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (j == 0 && k == 0) continue;
                        matrixStack.pushPose();
                        matrixStack.translate((double)j * 0.125, (double)k * 0.125, 0.001);
                        RenderUtil.renderSprite(matrixStack, vb2, 0xF000F0, index, tint, tint, tint, alpha, sprite);
                        matrixStack.popPose();
                    }
                }
            }
            RenderUtil.renderSprite(matrixStack, vertexBuilder, light, index, b, g, r, alpha, sprite);
        }
    }

    protected void renderName(T decoration, PoseStack matrixStack, MultiBufferSource buffer, int light) {
        Font font = Minecraft.getInstance().font;
        Component displayName = ((MLMapDecoration)decoration).getDisplayName();
        float width = font.width((FormattedText)displayName);
        float scale = Mth.clamp((float)(25.0f / width), (float)0.0f, (float)0.6666667f);
        matrixStack.pushPose();
        matrixStack.translate((double)(0.0f + (float)((MLMapDecoration)decoration).getX() / 2.0f + 64.0f - width * scale / 2.0f), (double)(0.0f + (float)((MLMapDecoration)decoration).getY() / 2.0f + 64.0f + 4.0f), (double)-0.025f);
        if (CompatHandler.MAP_ATLASES) {
            MapAtlasCompat.scaleDecorationText(matrixStack, width, scale);
        }
        matrixStack.scale(scale, scale, 1.0f);
        matrixStack.translate(0.0, 0.0, (double)-0.1f);
        font.drawInBatch(displayName, 0.0f, 0.0f, -1, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, Integer.MIN_VALUE, light);
        matrixStack.popPose();
    }
}

