/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.configured;

import com.mojang.blaze3d.platform.Lighting;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeConfig;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigScreen;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ForgeConfigHolder;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

public class CustomConfigSelectScreen
extends ModConfigSelectionScreen {
    public static final ResourceLocation MISC_ICONS = Moonlight.res("textures/gui/misc_icons.png");
    private static final Field FILE_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ModConfigSelectionScreen.FileItem.class, "modifyButton");
    private static final Field FILE_ITEM_CONFIG = CustomConfigScreen.findFieldOrNull(ModConfigSelectionScreen.FileItem.class, "config");
    private final BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory;
    private final ItemStack mainIcon;
    private final String modId;
    private final String modURL;

    public CustomConfigSelectScreen(String modId, ItemStack mainIcon, String displayName, Screen parent, BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory, ModConfigHolder ... specs) {
        this(modId, mainIcon, displayName, parent, configScreenFactory, CustomConfigSelectScreen.createConfigMap(specs));
    }

    public CustomConfigSelectScreen(String modId, ItemStack mainIcon, String displayName, Screen parent, BiFunction<CustomConfigSelectScreen, IModConfig, CustomConfigScreen> configScreenFactory, Map<ConfigType, Set<IModConfig>> configMap) {
        super(parent, (Component)Component.literal((String)displayName), configMap);
        this.configScreenFactory = configScreenFactory;
        this.mainIcon = mainIcon;
        this.modId = modId;
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).get();
        this.modURL = container.getModInfo().getModURL().map(URL::getPath).orElse(null);
    }

    public static ResourceLocation ensureNotNull(ResourceLocation background) {
        return background == null ? ResourceLocation.parse((String)"minecraft:textures/gui/options_background.png") : background;
    }

    public ItemStack getMainIcon() {
        return this.mainIcon;
    }

    public String getModId() {
        return this.modId;
    }

    public static void registerConfigScreen(String modId, Function<Screen, CustomConfigSelectScreen> screenSelectFactory) {
        ModContainer container = (ModContainer)ModList.get().getModContainerById(modId).get();
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(a, s) -> (Screen)screenSelectFactory.apply(s)));
    }

    private static Map<ConfigType, Set<IModConfig>> createConfigMap(ModConfigHolder ... specs) {
        EnumMap<ConfigType, Set<IModConfig>> modConfigMap = new EnumMap<ConfigType, Set<IModConfig>>(ConfigType.class);
        for (ModConfigHolder ss : specs) {
            ForgeConfigHolder s = (ForgeConfigHolder)ss;
            ModConfig modConfig = s.getModConfig();
            NeoForgeConfig forgeConfig = new NeoForgeConfig(modConfig);
            Set set = modConfigMap.computeIfAbsent(forgeConfig.getType(), a -> new HashSet());
            set.add(forgeConfig);
        }
        return modConfigMap;
    }

    private static ConfigType getType(ForgeConfigHolder s) {
        net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType t = s.getConfigType();
        if (t == net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType.CLIENT) {
            return ConfigType.CLIENT;
        }
        if (t == net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType.COMMON) {
            return ConfigType.UNIVERSAL;
        }
        return ConfigType.UNIVERSAL;
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        for (ListMenuScreen.Item i : entries) {
            if (!(i instanceof ModConfigSelectionScreen.FileItem)) continue;
            ModConfigSelectionScreen.FileItem item = (ModConfigSelectionScreen.FileItem)i;
            try {
                FILE_ITEM_BUTTON.setAccessible(true);
                FILE_ITEM_CONFIG.setAccessible(true);
                FILE_ITEM_BUTTON.set(i, this.createModifyButton((IModConfig)FILE_ITEM_CONFIG.get(item)));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private Button createModifyButton(IModConfig config) {
        String langKey = "configured.gui.modify";
        return new IconButton(0, 0, 33, 0, 60, (Component)Component.translatable((String)langKey), onPress -> Minecraft.getInstance().setScreen((Screen)this.configScreenFactory.apply(this, config)));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Lighting.setupFor3DItems();
        int titleWidth = this.font.width((FormattedText)this.title) + 35;
        graphics.renderFakeItem(this.mainIcon, this.width / 2 + titleWidth / 2 - 17, 2);
        graphics.renderFakeItem(this.mainIcon, this.width / 2 - titleWidth / 2, 2);
        if (this.modURL != null && MthUtils.isWithinRectangle(this.width / 2 - 90, 2, 180, 16, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, this.font.split((FormattedText)Component.translatable((String)"gui.moonlight.open_mod_page", (Object[])new Object[]{this.modId}), 200), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.modURL != null && MthUtils.isWithinRectangle(this.width / 2 - 90, 2, 180, 16, (int)mouseX, (int)mouseY)) {
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.modURL));
            this.handleComponentClicked(style);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

