/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SoftFluidRegistry {
    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Moonlight.res("soft_fluid"));

    public static Holder<SoftFluid> getEmpty() {
        return BuiltInSoftFluids.EMPTY;
    }

    public static SoftFluid empty() {
        return BuiltInSoftFluids.EMPTY.value();
    }

    public static Registry<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static Registry<SoftFluid> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(KEY);
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.hackyGetRegistry().stream().toList();
    }

    public static Collection<Holder.Reference<SoftFluid>> getHolders() {
        return SoftFluidRegistry.hackyGetRegistry().holders().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.hackyGetRegistry().entrySet();
    }

    public static Holder<SoftFluid> getHolder(ResourceLocation id) {
        Optional<Holder.Reference<SoftFluid>> opt = SoftFluidRegistry.getOptionalHolder(id);
        if (opt.isPresent()) {
            return (Holder)opt.get();
        }
        return SoftFluidRegistry.getEmpty();
    }

    public static Optional<Holder.Reference<SoftFluid>> getOptionalHolder(ResourceLocation id) {
        id = SoftFluidRegistry.backwardsCompat(id);
        return SoftFluidRegistry.hackyGetRegistry().getHolder(ResourceKey.create(KEY, (ResourceLocation)id));
    }

    @NotNull
    private static ResourceLocation backwardsCompat(ResourceLocation id) {
        String namespace = id.getNamespace();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.getPath());
        }
        return id;
    }
}

