/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.TickRateModulation;
import com.glodblock.github.extendedae.api.IRecipeMachine;
import com.glodblock.github.glodium.recipe.RecipeSearchContext;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class RecipeExecutor<T extends Recipe<?>> {
    private final IRecipeMachine<?, T> machine;
    private final int maxTime;
    private final Function<T, ItemStack> outputGetter;
    private final int energyMultiplier;

    public RecipeExecutor(IRecipeMachine<?, T> machine, Function<T, ItemStack> outputGetter, int maxTime) {
        this(machine, outputGetter, maxTime, 10);
    }

    public RecipeExecutor(IRecipeMachine<?, T> machine, Function<T, ItemStack> outputGetter, int maxTime, int energyMultiplier) {
        this.machine = machine;
        this.maxTime = maxTime;
        this.outputGetter = outputGetter;
        this.energyMultiplier = energyMultiplier;
    }

    public TickRateModulation execute(int speed, boolean usePower) {
        RecipeSearchContext<?, T> ctx = this.machine.getContext();
        IManagedGridNode mainNode = this.machine.getNode();
        IEnergySource power = this.machine.getEnergy();
        RecipeHolder runRecipe = ctx.currentRecipe;
        InternalInventory output = this.machine.getOutput();
        if (runRecipe != null) {
            this.machine.setWorking(true);
            if (usePower) {
                if (mainNode != null) {
                    mainNode.ifPresent(grid -> {
                        IEnergyService eg = grid.getEnergyService();
                        IEnergySource src = power;
                        int powerConsumption = this.energyMultiplier * speed;
                        double powerThreshold = (double)powerConsumption - 0.01;
                        double powerReq = 0.0;
                        if (src != null) {
                            powerReq = src.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                        }
                        if (powerReq <= powerThreshold) {
                            src = eg;
                            powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                        }
                        if (src != null && powerReq > powerThreshold) {
                            src.extractAEPower((double)powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                            this.machine.addProgress(speed);
                        }
                    });
                }
            } else {
                this.machine.addProgress(speed);
            }
            if (this.machine.getProgress() >= this.maxTime) {
                this.machine.setProgress(0);
                ItemStack outputStack = this.outputGetter.apply(runRecipe.value()).copy();
                if (ctx.testRecipe(runRecipe)) {
                    if (output.insertItem(0, outputStack, true).isEmpty()) {
                        ctx.runRecipe(runRecipe);
                        output.insertItem(0, outputStack, false);
                    } else {
                        ctx.stuck = true;
                    }
                }
                ctx.currentRecipe = null;
            }
            return TickRateModulation.URGENT;
        }
        if (ctx.shouldTick()) {
            ctx.findRecipe();
        }
        if (ctx.currentRecipe == null) {
            this.machine.setWorking(false);
        }
        return TickRateModulation.FASTER;
    }
}

