/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.blockentity.AEBaseBlockEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FCUtil {
    public static void replaceTile(Level world, BlockPos pos, BlockEntity oldTile, BlockEntity newTile, BlockState newBlock) {
        CompoundTag contents = oldTile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
        world.removeBlockEntity(pos);
        world.removeBlock(pos, false);
        world.setBlock(pos, newBlock, 3);
        world.setBlockEntity(newTile);
        newTile.loadWithComponents(contents, (HolderLookup.Provider)world.registryAccess());
        if (newTile instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity aeTile = (AEBaseBlockEntity)newTile;
            aeTile.markForUpdate();
        } else {
            newTile.setChanged();
        }
    }

    public static boolean ejectInv(Level world, BlockPos pos, InternalInventory inv, Predicate<? super BlockEntity> shouldIgnore) {
        for (Direction dir : Direction.values()) {
            ItemTransfer target;
            BlockEntity te = world.getBlockEntity(pos.relative(dir));
            if (te == null || shouldIgnore.test((BlockEntity)te) || (target = InternalInventory.wrapExternal((Level)world, (BlockPos)pos.relative(dir), (Direction)dir.getOpposite())) == null) continue;
            int startItems = inv.getStackInSlot(0).getCount();
            inv.insertItem(0, target.addItems(inv.extractItem(0, 64, false)), false);
            int endItems = inv.getStackInSlot(0).getCount();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    public static int speedCardMap(int card) {
        return FCUtil.speedCardMap(card, 1);
    }

    public static int speedCardMap(int card, int multi) {
        return multi * (switch (card) {
            default -> 2;
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 10;
            case 4 -> 50;
        });
    }

    public static String[] trimSplit(String str) {
        String[] sp = str.split(",");
        for (int i = 0; i < sp.length; ++i) {
            sp[i] = sp[i].trim();
        }
        return sp;
    }
}

