/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.upgrades.IUpgradeableObject;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.api.ThresholdMode;
import com.glodblock.github.extendedae.common.parts.PartThresholdExportBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.SEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ContainerThresholdExportBus
extends UpgradeableMenu<PartThresholdExportBus>
implements IActionHolder {
    public static final MenuType<ContainerThresholdExportBus> TYPE = MenuTypeBuilder.create(ContainerThresholdExportBus::new, PartThresholdExportBus.class).build(ExtendedAE.id("threshold_export_bus"));
    private final ActionMap actions = ActionMap.create();
    @GuiSync(value=7)
    private ThresholdMode mode = ThresholdMode.GREATER;

    public ContainerThresholdExportBus(int id, Inventory ip, PartThresholdExportBus host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.actions.put("set", o -> this.setMode((Integer)o.get(0)));
        this.actions.put("update", o -> {
            Player patt0$temp = this.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                EAENetworkHandler.INSTANCE.sendTo((IMessage)new SEAEGenericPacket("init", this.mode.ordinal()), sp);
            }
        });
    }

    protected void setupConfig() {
        this.addExpandableConfigSlots((GenericStackInv)((PartThresholdExportBus)this.getHost()).getConfig(), 2, 9, 5);
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.CAPACITY_CARD);
        return upgrades > idx;
    }

    public boolean isConfigSlot(Slot slot) {
        return this.getSlots(SlotSemantics.CONFIG).contains(slot);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.mode != ((PartThresholdExportBus)this.getHost()).getMode()) {
            this.mode = ((PartThresholdExportBus)this.getHost()).getMode();
        }
    }

    public void setMode(int mode) {
        ((PartThresholdExportBus)this.getHost()).setMode(ThresholdMode.values()[mode]);
        this.broadcastChanges();
    }

    public ThresholdMode getMode() {
        return this.mode;
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

