/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.parts.PartTagStorageBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.SEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerTagStorageBus
extends UpgradeableMenu<PartTagStorageBus>
implements IActionHolder {
    private final ActionMap actions = ActionMap.create();
    private static final String ACTION_PARTITION = "partition";
    public static final MenuType<ContainerTagStorageBus> TYPE = MenuTypeBuilder.create(ContainerTagStorageBus::new, PartTagStorageBus.class).build(ExtendedAE.id("tag_storage_bus"));
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo filterOnExtract = YesNo.YES;
    @GuiSync(value=8)
    @Nullable
    public Component connectedTo;
    @GuiSync(value=9)
    public String exp = "";
    @GuiSync(value=10)
    public String exp2 = "";

    public ContainerTagStorageBus(int id, Inventory ip, PartTagStorageBus te) {
        super(TYPE, id, ip, (IUpgradeableObject)te);
        this.registerClientAction(ACTION_PARTITION, this::partition);
        this.actions.put("set", o -> this.setExp((String)o.get(0), (Boolean)o.get(1)));
        this.actions.put("update", o -> {
            Player patt0$temp = this.getPlayer();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                EAENetworkHandler.INSTANCE.sendTo((IMessage)new SEAEGenericPacket("init", this.exp, this.exp2), sp);
            }
        });
        this.connectedTo = te.getConnectedToDescription();
    }

    protected void setupConfig() {
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.connectedTo = ((PartTagStorageBus)this.getHost()).getConnectedToDescription();
        if (!this.exp.equals(((PartTagStorageBus)this.getHost()).getTagFilter(true))) {
            this.exp = ((PartTagStorageBus)this.getHost()).getTagFilter(true);
        }
        if (!this.exp2.equals(((PartTagStorageBus)this.getHost()).getTagFilter(false))) {
            this.exp2 = ((PartTagStorageBus)this.getHost()).getTagFilter(false);
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
        this.setFilterOnExtract((YesNo)cm.getSetting(Settings.FILTER_ON_EXTRACT));
    }

    public boolean isSlotEnabled(int idx) {
        return false;
    }

    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_PARTITION);
            return;
        }
        this.broadcastChanges();
    }

    public void setExp(String exp, boolean isWhite) {
        ((PartTagStorageBus)this.getHost()).setTagFilter(exp, isWhite);
        this.broadcastChanges();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getFilterOnExtract() {
        return this.filterOnExtract;
    }

    public void setFilterOnExtract(YesNo filterOnExtract) {
        this.filterOnExtract = filterOnExtract;
    }

    @Nullable
    public Component getConnectedTo() {
        return this.connectedTo;
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

