/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.FullnessMode;
import appeng.api.config.OperationMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.tileentities.TileExIOPort;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class ContainerExIOPort
extends UpgradeableMenu<TileExIOPort> {
    public static final MenuType<ContainerExIOPort> TYPE = MenuTypeBuilder.create(ContainerExIOPort::new, TileExIOPort.class).build(ExtendedAE.id("ex_ioport"));
    @GuiSync(value=2)
    public FullnessMode fMode = FullnessMode.EMPTY;
    @GuiSync(value=3)
    public OperationMode opMode = OperationMode.EMPTY;

    public ContainerExIOPort(int id, Inventory ip, TileExIOPort host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
    }

    protected void setupConfig() {
        int i;
        InternalInventory cells = ((TileExIOPort)this.getHost()).getSubInventory(ISegmentedInventory.CELLS);
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.STORAGE_CELLS, cells, i), SlotSemantics.MACHINE_INPUT);
        }
        for (i = 0; i < 6; ++i) {
            this.addSlot((Slot)new OutputSlot(cells, 6 + i, RestrictedInputSlot.PlacableItemType.STORAGE_CELLS.icon), SlotSemantics.MACHINE_OUTPUT);
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setOperationMode((OperationMode)cm.getSetting(Settings.OPERATION_MODE));
        this.setFullMode((FullnessMode)cm.getSetting(Settings.FULLNESS_MODE));
        this.setRedStoneMode((RedstoneMode)cm.getSetting(Settings.REDSTONE_CONTROLLED));
    }

    public FullnessMode getFullMode() {
        return this.fMode;
    }

    private void setFullMode(FullnessMode fMode) {
        this.fMode = fMode;
    }

    public OperationMode getOperationMode() {
        return this.opMode;
    }

    private void setOperationMode(OperationMode opMode) {
        this.opMode = opMode;
    }
}

