/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.inventories.InternalInventory;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixBase;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixCrafter;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixPattern;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.SAssemblerMatrixUpdate;
import com.glodblock.github.extendedae.network.packet.SEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerAssemblerMatrix
extends AEBaseMenu
implements IActionHolder {
    public static final MenuType<ContainerAssemblerMatrix> TYPE = MenuTypeBuilder.create(ContainerAssemblerMatrix::new, TileAssemblerMatrixBase.class).build(ExtendedAE.id("assembler_matrix"));
    private final ActionMap actions = ActionMap.create();
    private final List<PatternSlotTracker> trackers = new ArrayList<PatternSlotTracker>();
    private final Int2ReferenceMap<PatternSlotTracker> trackerMap = new Int2ReferenceOpenHashMap();
    private final TileAssemblerMatrixBase host;
    private int runningThreads = 0;

    public ContainerAssemblerMatrix(int id, Inventory playerInventory, TileAssemblerMatrixBase host) {
        super(TYPE, id, playerInventory, (Object)host);
        this.actions.put("cancel", o -> this.cancel());
        this.host = host;
        this.setupPatternInventory();
        this.createPlayerInventorySlots(playerInventory);
    }

    private void cancel() {
        ClusterAssemblerMatrix cluster = this.host.getCluster();
        if (cluster != null && !cluster.isDestroyed()) {
            cluster.getBlockEntities().forEachRemaining(te -> {
                if (te instanceof TileAssemblerMatrixCrafter) {
                    TileAssemblerMatrixCrafter crafter = (TileAssemblerMatrixCrafter)((Object)te);
                    crafter.stop();
                }
            });
        }
    }

    private int runningThreads() {
        ClusterAssemblerMatrix c = this.host.getCluster();
        if (c == null) {
            return 0;
        }
        return c.getBusyCrafterAmount();
    }

    protected ItemStack transferStackToMenu(ItemStack input) {
        InternalInventory slot = this.getAvailableSlot();
        if (slot != null) {
            return slot.addItems(input);
        }
        return input;
    }

    @Nullable
    private InternalInventory getAvailableSlot() {
        for (PatternSlotTracker tr : this.trackerMap.values()) {
            for (int x = 0; x < tr.server.size(); ++x) {
                if (!tr.server.getStackInSlot(x).isEmpty()) continue;
                return new FilteredInternalInventory(tr.server.getSlotInv(x), (IAEItemFilter)new TileAssemblerMatrixPattern.Filter(() -> this.getHost().getLevel()));
            }
        }
        return null;
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        PatternSlotTracker inv = (PatternSlotTracker)this.trackerMap.get((int)id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new TileAssemblerMatrixPattern.Filter(() -> this.getHost().getLevel()));
        ItemStack carried = this.getCarried();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.isEmpty()) {
                    ItemStack inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.isEmpty()) {
                        this.setCarried(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.copy();
                    ItemStack inHand = carried.copy();
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                    this.setCarried(ItemStack.EMPTY);
                    this.setCarried(patternSlot.addItems(inHand.copy()));
                    if (this.getCarried().isEmpty()) {
                        this.setCarried(inSlot);
                        break;
                    }
                    this.setCarried(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.setCarried(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.isEmpty()) {
                    ItemStack extra = carried.split(1);
                    if (!extra.isEmpty()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.isEmpty()) break;
                    carried.grow(extra.getCount());
                    break;
                }
                if (is.isEmpty()) break;
                this.setCarried(patternSlot.extractItem(0, (is.getCount() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = patternSlot.getStackInSlot(0).copy();
                if (!player.getInventory().add(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, ItemStack.EMPTY);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.getInventory().add(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, ItemStack.EMPTY);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.getAbilities().instabuild || !carried.isEmpty()) break;
                this.setCarried(is.isEmpty() ? ItemStack.EMPTY : is.copy());
            }
        }
    }

    public void broadcastChanges() {
        if (this.isClientSide()) {
            return;
        }
        super.broadcastChanges();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (PatternSlotTracker tracker : this.trackers) {
                if (tracker.init) {
                    SAssemblerMatrixUpdate ptk = tracker.createPacket();
                    if (ptk == null) continue;
                    EAENetworkHandler.INSTANCE.sendTo(ptk, player2);
                    continue;
                }
                tracker.init = true;
                EAENetworkHandler.INSTANCE.sendTo(tracker.fullPacket(), player2);
            }
            int newRunningThreads = this.runningThreads();
            if (this.runningThreads != newRunningThreads) {
                this.runningThreads = newRunningThreads;
                EAENetworkHandler.INSTANCE.sendTo((IMessage)new SEAEGenericPacket("running_update", newRunningThreads), player2);
            }
        }
    }

    private void setupPatternInventory() {
        if (this.isClientSide()) {
            return;
        }
        this.trackers.clear();
        this.trackerMap.clear();
        ClusterAssemblerMatrix cluster = this.host.getCluster();
        if (cluster != null && !cluster.isDestroyed()) {
            for (TileAssemblerMatrixPattern pattern : cluster.getPatterns()) {
                PatternSlotTracker tracker = new PatternSlotTracker(pattern);
                this.trackers.add(tracker);
                this.trackerMap.put(pattern.getLocateID(), (Object)tracker);
            }
        }
    }

    public TileAssemblerMatrixBase getHost() {
        return this.host;
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    private static class PatternSlotTracker {
        private final TileAssemblerMatrixPattern invHost;
        private final InternalInventory client;
        private final InternalInventory server;
        private final Int2ObjectMap<ItemStack> changedMap = new Int2ObjectOpenHashMap();
        private boolean init = false;

        public PatternSlotTracker(TileAssemblerMatrixPattern host) {
            this.invHost = host;
            this.client = new AppEngInternalInventory(36);
            this.server = host.getPatternInventory();
        }

        private Int2ObjectMap<ItemStack> getChangedMap() {
            this.changedMap.clear();
            for (int x = 0; x < this.server.size(); ++x) {
                ItemStack cs;
                ItemStack ss = this.server.getStackInSlot(x);
                if (ItemStack.isSameItemSameComponents((ItemStack)ss, (ItemStack)(cs = this.client.getStackInSlot(x)))) continue;
                this.changedMap.put(x, (Object)ss.copy());
                this.client.setItemDirect(x, ss.copy());
            }
            return this.changedMap;
        }

        private Int2ObjectMap<ItemStack> getFullMap() {
            this.changedMap.clear();
            for (int x = 0; x < this.server.size(); ++x) {
                this.changedMap.put(x, (Object)this.server.getStackInSlot(x).copy());
            }
            return this.changedMap;
        }

        @Nullable
        public SAssemblerMatrixUpdate createPacket() {
            Int2ObjectMap<ItemStack> map = this.getChangedMap();
            if (map.isEmpty()) {
                return null;
            }
            return new SAssemblerMatrixUpdate(this.invHost.getLocateID(), map);
        }

        public SAssemblerMatrixUpdate fullPacket() {
            return new SAssemblerMatrixUpdate(this.invHost.getLocateID(), this.getFullMap());
        }
    }
}

