/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities.matrix;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.helpers.patternprovider.PatternContainer;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.FreqGenerator;
import com.glodblock.github.extendedae.common.me.matrix.ClusterAssemblerMatrix;
import com.glodblock.github.extendedae.common.tileentities.matrix.TileAssemblerMatrixFunction;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileAssemblerMatrixPattern
extends TileAssemblerMatrixFunction
implements InternalInventoryHost,
ICraftingProvider,
PatternContainer {
    public static final int INV_SIZE = 36;
    private static final FreqGenerator<Integer> G = FreqGenerator.createInt();
    private final AppEngInternalInventory patternInventory;
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private int locateID = 0;

    public TileAssemblerMatrixPattern(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileAssemblerMatrixPattern.class, TileAssemblerMatrixPattern::new, (Block)EAESingletons.ASSEMBLER_MATRIX_PATTERN), pos, blockState);
        this.patternInventory = new AppEngInternalInventory((InternalInventoryHost)this, 36, 1);
        this.patternInventory.setFilter((IAEItemFilter)new Filter(() -> ((TileAssemblerMatrixPattern)this).getLevel()));
        this.getMainNode().addService(ICraftingProvider.class, (IGridNodeService)this);
    }

    @Override
    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        this.patternInventory.writeToNBT(data, "pattern", registries);
    }

    @Override
    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.patternInventory.readFromNBT(data, "pattern", registries);
    }

    public AppEngInternalInventory getPatternInventory() {
        return this.patternInventory;
    }

    public int getLocateID() {
        if (this.locateID == 0) {
            this.locateID = G.genFreq();
        }
        return this.locateID;
    }

    public void updatePatterns() {
        this.patterns.clear();
        for (ItemStack stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getLevel());
            if (details == null) continue;
            this.patterns.add(details);
        }
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack pattern : this.patternInventory) {
            drops.add(pattern);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.patternInventory.clear();
    }

    @Override
    public void add(ClusterAssemblerMatrix c) {
        c.addPattern(this);
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.saveChanges();
        this.updatePatterns();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.updatePatterns();
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.isFormed() && this.getMainNode().isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        return this.cluster.pushCraftingJob(patternDetails, inputHolder);
    }

    public boolean isBusy() {
        return this.cluster == null || this.cluster.isBusy();
    }

    @Nullable
    public IGrid getGrid() {
        return this.getMainNode().getGrid();
    }

    public InternalInventory getTerminalPatternInventory() {
        return this.patternInventory;
    }

    public PatternContainerGroup getTerminalGroup() {
        AEItemKey icon = AEItemKey.of((ItemLike)EAESingletons.ASSEMBLER_MATRIX_PATTERN);
        return new PatternContainerGroup(icon, icon.getDisplayName(), List.of(Component.translatable((String)"gui.extendedae.assembler_matrix.pattern")));
    }

    public record Filter(Supplier<Level> world) implements IAEItemFilter
    {
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.world.get()) instanceof IMolecularAssemblerSupportedPattern;
        }
    }
}

