/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import appeng.util.SettingsFrom;
import com.glodblock.github.extendedae.api.ThresholdMode;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.container.ContainerThresholdExportBus;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartThresholdExportBus
extends ExportBusPart {
    public static List<ResourceLocation> MODELS = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"extendedae", (String)"part/threshold_export_bus_base"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_on"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_off"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/export_bus_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});
    private ConfigInventory config;
    private ThresholdMode mode = ThresholdMode.GREATER;

    public PartThresholdExportBus(IPartItem<?> partItem) {
        super(partItem);
    }

    public void setMode(ThresholdMode mode) {
        this.mode = mode;
    }

    public ThresholdMode getMode() {
        return this.mode;
    }

    public void readFromNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.readFromNBT(extra, registries);
        this.config.readFromChildTag(extra, "config2", registries);
        this.mode = ThresholdMode.values()[extra.getByte("cmod")];
    }

    public void writeToNBT(CompoundTag extra, HolderLookup.Provider registries) {
        super.writeToNBT(extra, registries);
        this.config.writeToChildTag(extra, "config2", registries);
        extra.putByte("cmod", (byte)this.mode.ordinal());
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = ConfigInventory.configStacks((int)63).supportedTypes((Collection)StackWorldBehaviors.withExportStrategy()).changeListener(() -> Ae2Reflect.updatePartState((IOBusPart)this)).allowOverstacking(true).build();
        }
        return this.config;
    }

    public void importSettings(SettingsFrom mode, DataComponentMap input, @Nullable Player player) {
        super.importSettings(mode, input, player);
        CompoundTag tag = (CompoundTag)input.get(EAESingletons.EXTRA_SETTING);
        if (tag != null && tag.contains("threshold_mode")) {
            this.mode = ThresholdMode.values()[tag.getByte("threshold_mode")];
        }
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            CompoundTag tag = new CompoundTag();
            tag.putByte("threshold_mode", (byte)this.mode.ordinal());
            output.set(EAESingletons.EXTRA_SETTING, (Object)tag);
        }
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = Ae2Reflect.getExportContext(this, storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null || !this.checkAmount(stack, storageService)) continue;
            AEKey what = stack.what();
            int transferFactor = what.getAmountPerOperation();
            long amount = (long)context.getOperationsRemaining() * (long)transferFactor;
            amount = this.getExportStrategy().transfer(context, what, amount);
            if (amount <= 0L) continue;
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)transferFactor));
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    private boolean checkAmount(@NotNull GenericStack stack, @NotNull IStorageService service) {
        long thr = stack.amount();
        long stored = service.getCachedInventory().get(stack.what());
        if (this.mode == ThresholdMode.GREATER) {
            return stored >= thr;
        }
        if (this.mode == ThresholdMode.LOWER) {
            return stored <= thr;
        }
        return false;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    protected MenuType<?> getMenuType() {
        return ContainerThresholdExportBus.TYPE;
    }
}

