/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.AECapabilities;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.storage.AEKeySlotFilter;
import appeng.helpers.InterfaceLogic;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.parts.PartModel;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.common.parts.PartExInterface;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.glodblock.github.extendedae.container.ContainerExInterface;
import com.glodblock.github.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class PartOversizeInterface
extends PartExInterface {
    public static List<ResourceLocation> MODELS = Arrays.asList(ResourceLocation.fromNamespaceAndPath((String)"extendedae", (String)"part/oversize_interface"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_on"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_off"), ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"part/interface_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(0), MODELS.get(3)});

    public PartOversizeInterface(IPartItem<?> partItem) {
        super(partItem);
        InterfaceLogic logic = this.getInterfaceLogic();
        Ae2Reflect.setInterfaceConfig(logic, new OversizeConfigInv(AEKeyTypes.getAll(), null, GenericStackInv.Mode.CONFIG_STACKS, 36, () -> Ae2Reflect.onInterfaceConfigChange(logic), false));
        Ae2Reflect.setInterfaceStorage(logic, new OversizeConfigInv(AEKeyTypes.getAll(), (slot, key) -> Ae2Reflect.isInterfaceSlotAllowed(logic, slot, key), GenericStackInv.Mode.STORAGE, 36, () -> Ae2Reflect.onInterfaceStorageChange(logic), false));
        this.getConfig().useRegisteredCapacities();
        this.getStorage().useRegisteredCapacities();
    }

    @Override
    public void openMenu(Player player, MenuHostLocator locator) {
        MenuOpener.open(ContainerExInterface.TYPE_OVERSIZE, (Player)player, (MenuHostLocator)locator);
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(ContainerExInterface.TYPE_OVERSIZE, (Player)player, (MenuHostLocator)subMenu.getLocator());
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public static void registerCapability(RegisterPartCapabilitiesEvent event) {
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.getInterfaceLogic().getStorage(), PartOversizeInterface.class);
        event.register(AECapabilities.ME_STORAGE, (part, context) -> part.getInterfaceLogic().getInventory(), PartOversizeInterface.class);
    }

    private static class OversizeConfigInv
    extends ConfigInventory {
        protected OversizeConfigInv(Set<AEKeyType> supportedTypes, @Nullable AEKeySlotFilter slotFilter, GenericStackInv.Mode mode, int size, @Nullable Runnable listener, boolean allowOverstacking) {
            super(supportedTypes, slotFilter, mode, size, listener, allowOverstacking);
        }

        public long getMaxAmount(AEKey key) {
            try {
                return Math.multiplyExact(super.getMaxAmount(key), EAEConfig.oversizeMultiplier);
            }
            catch (Exception e) {
                return Long.MAX_VALUE;
            }
        }
    }
}

