/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.taglist;

import appeng.api.stacks.AEKey;
import appeng.util.prioritylist.IPartitionList;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class TagPriorityList
implements IPartitionList {
    private final Set<TagKey<?>> whiteSet;
    private final Set<TagKey<?>> blackSet;
    private final String tagExp;
    private final Reference2BooleanMap<Object> memory = new Reference2BooleanOpenHashMap();

    public TagPriorityList(Set<TagKey<?>> whiteKeys, Set<TagKey<?>> blackKeys, String tagExp) {
        this.whiteSet = whiteKeys;
        this.blackSet = blackKeys;
        this.tagExp = tagExp;
    }

    public boolean isListed(AEKey input) {
        Object key = input.getPrimaryKey();
        return this.memory.computeIfAbsent(key, this::eval);
    }

    public boolean isEmpty() {
        return this.tagExp.isEmpty();
    }

    public Iterable<AEKey> getItems() {
        return List.of();
    }

    private boolean eval(@NotNull Object obj) {
        Holder.Reference refer = null;
        if (obj instanceof Item) {
            Item item = (Item)obj;
            refer = item.builtInRegistryHolder();
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            refer = fluid.builtInRegistryHolder();
        }
        if (refer != null) {
            if (this.whiteSet.isEmpty()) {
                return false;
            }
            boolean pass = refer.tags().anyMatch(this.whiteSet::contains);
            if (pass) {
                if (!this.blackSet.isEmpty()) {
                    return refer.tags().noneMatch(this.blackSet::contains);
                }
                return true;
            }
        }
        return false;
    }
}

