/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.items.AEBaseItem;
import appeng.parts.PartPlacement;
import appeng.util.Platform;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.items.ItemMEPackingTape;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ItemPackedDevice
extends AEBaseItem {
    public ItemPackedDevice() {
        super(new Item.Properties().stacksTo(1));
    }

    public void addToMainCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
    }

    public void appendHoverText(@NotNull ItemStack is, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext ctx, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        if (is.has(EAESingletons.IS_PART)) {
            boolean isPart = Boolean.TRUE.equals(is.get(EAESingletons.IS_PART));
            if (isPart) {
                Item item;
                ItemMEPackingTape.PartPackageData data = (ItemMEPackingTape.PartPackageData)is.get(EAESingletons.TAPE_PART_DATA);
                if (data != null && (item = (Item)BuiltInRegistries.ITEM.get(data.id())) != Items.AIR) {
                    Component name = new ItemStack((ItemLike)item).getDisplayName();
                    lines.add((Component)Component.translatable((String)"packaged_device.tooltip", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY));
                    return;
                }
            } else {
                Block item;
                ItemMEPackingTape.TilePackageData data = (ItemMEPackingTape.TilePackageData)is.get(EAESingletons.TAPE_TILE_DATA);
                if (data != null && (item = (Block)BuiltInRegistries.BLOCK.get(data.block())) != Blocks.AIR) {
                    Component name = new ItemStack((ItemLike)item).getDisplayName();
                    lines.add((Component)Component.translatable((String)"packaged_device.tooltip", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY));
                    return;
                }
            }
        }
        lines.add((Component)Component.translatable((String)"packaged_device.error.tooltip").withStyle(ChatFormatting.RED));
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockState state;
        Item item;
        Direction side = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        ItemStack pack = context.getItemInHand();
        if (!pack.has(EAESingletons.IS_PART)) {
            return InteractionResult.FAIL;
        }
        boolean isPart = Boolean.TRUE.equals(pack.get(EAESingletons.IS_PART));
        if (isPart) {
            ItemMEPackingTape.PartPackageData data = (ItemMEPackingTape.PartPackageData)pack.get(EAESingletons.TAPE_PART_DATA);
            if (data == null) {
                return InteractionResult.FAIL;
            }
            Item item2 = (Item)BuiltInRegistries.ITEM.get(data.id());
            if (item2 instanceof IPartItem) {
                IPartItem partItem = (IPartItem)item2;
                PartPlacement.Placement placement = PartPlacement.getPartPlacement((Player)context.getPlayer(), (Level)world, (ItemStack)new ItemStack((ItemLike)partItem), (BlockPos)pos, (Direction)side, (Vec3)context.getClickLocation());
                if (placement != null) {
                    IPart part = PartPlacement.placePart((Player)context.getPlayer(), (Level)world, (IPartItem)partItem, null, (BlockPos)placement.pos(), (Direction)placement.side());
                    if (part != null) {
                        part.readFromNBT(data.context(), (HolderLookup.Provider)world.registryAccess());
                        pack.shrink(1);
                        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                    }
                    Platform.sendImmediateBlockEntityUpdate((Player)context.getPlayer(), (BlockPos)pos);
                }
            }
            return InteractionResult.PASS;
        }
        ItemMEPackingTape.TilePackageData data = (ItemMEPackingTape.TilePackageData)pack.get(EAESingletons.TAPE_TILE_DATA);
        if (data == null) {
            return InteractionResult.FAIL;
        }
        BlockEntityType block = (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(data.id());
        if (block != null && (item = (state = NbtUtils.readBlockState((HolderGetter)world.holderLookup(Registries.BLOCK), (CompoundTag)data.state())).getBlock().asItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (context.getPlayer() != null) {
                BlockPos posNew;
                BlockEntity te;
                BlockPlaceContext ctxB = new BlockPlaceContext(world, context.getPlayer(), context.getHand(), new ItemStack((ItemLike)blockItem), context.hitResult);
                if ((ctxB = blockItem.updatePlacementContext(ctxB)) != null && blockItem.place(ctxB) != InteractionResult.FAIL && (te = block.create(posNew = ctxB.getClickedPos(), state)) != null) {
                    world.setBlock(posNew, state, 3);
                    world.setBlockEntity(te);
                    te.loadWithComponents(data.context(), (HolderLookup.Provider)world.registryAccess());
                    if (te instanceof AEBaseBlockEntity) {
                        AEBaseBlockEntity aeTile = (AEBaseBlockEntity)te;
                        aeTile.markForUpdate();
                    } else {
                        te.setChanged();
                    }
                    pack.shrink(1);
                    return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }
}

