/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.inventory;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.ids.AEComponents;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.api.VoidMode;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.items.ItemVoidCell;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VoidCellInventory
implements StorageCell {
    private final ItemStack stack;
    @Nullable
    private final ISaveProvider container;
    private final IPartitionList partitionList;
    private final IncludeExclude partitionListMode;
    private final VoidMode voidMode;
    private final ItemVoidCell type;
    private Object2LongMap<AEKey> storedAmounts;
    private double voidEnergy;
    private boolean isPersisted = true;
    public static final ICellHandler HANDLER = new Handler();

    public VoidCellInventory(ItemStack stack, @Nullable ISaveProvider container) {
        if (!(stack.getItem() instanceof ItemVoidCell)) {
            throw new IllegalArgumentException("Cell isn't a void cell!");
        }
        this.stack = stack;
        this.container = container;
        this.type = (ItemVoidCell)stack.getItem();
        this.voidMode = (VoidMode)((Object)stack.getOrDefault(EAESingletons.VOID_MODE, (Object)VoidMode.TRASH));
        this.voidEnergy = (Double)stack.getOrDefault(EAESingletons.VOID_ENERGY, (Object)0.0);
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        boolean hasInverter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        boolean isFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        if (isFuzzy) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        builder.addAll((Iterable)config.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
    }

    public boolean isPartitioned() {
        return !this.partitionList.isEmpty();
    }

    private List<GenericStack> getStoredStacks() {
        return (List)this.stack.getOrDefault(AEComponents.STORAGE_CELL_INV, List.of());
    }

    private ConfigInventory getConfigInventory() {
        return this.type.getConfigInventory(this.stack);
    }

    private IUpgradeInventory getUpgradesInventory() {
        return this.type.getUpgrades(this.stack);
    }

    private FuzzyMode getFuzzyMode() {
        return this.type.getFuzzyMode(this.stack);
    }

    public CellState getStatus() {
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return 1.0;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        ArrayList<GenericStack> stacks = new ArrayList<GenericStack>(this.storedAmounts.size());
        for (Object2LongMap.Entry entry : this.storedAmounts.object2LongEntrySet()) {
            long amount = entry.getLongValue();
            if (amount <= 0L) continue;
            stacks.add(new GenericStack((AEKey)entry.getKey(), amount));
        }
        if (stacks.isEmpty()) {
            this.stack.remove(AEComponents.STORAGE_CELL_INV);
        } else {
            this.stack.set(AEComponents.STORAGE_CELL_INV, stacks);
        }
        if (this.voidEnergy <= 0.0) {
            this.stack.remove(EAESingletons.VOID_ENERGY);
        } else {
            this.stack.set(EAESingletons.VOID_ENERGY, (Object)this.voidEnergy);
        }
        this.isPersisted = true;
    }

    private Object2LongMap<AEKey> getCellItems() {
        if (this.storedAmounts == null) {
            this.storedAmounts = new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.storedAmounts;
    }

    private void loadCellItems() {
        List<GenericStack> stacks = this.getStoredStacks();
        for (GenericStack stack : stacks) {
            this.storedAmounts.put((Object)stack.what(), stack.amount());
        }
    }

    public void getAvailableStacks(KeyCounter out) {
        for (Object2LongMap.Entry entry : this.getCellItems().object2LongEntrySet()) {
            out.add((AEKey)entry.getKey(), entry.getLongValue());
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || what == null) {
            return 0L;
        }
        if (this.partitionList.isEmpty()) {
            return 0L;
        }
        if (!this.partitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            this.voidEnergy += (double)amount / (double)what.getAmountPerUnit();
            this.fillOutput();
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long currentAmount = this.getCellItems().getLong((Object)what);
        if (currentAmount > 0L) {
            if (amount >= currentAmount) {
                if (mode == Actionable.MODULATE) {
                    this.getCellItems().remove((Object)what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                this.getCellItems().put((Object)what, currentAmount - amount);
                this.saveChanges();
            }
            return amount;
        }
        return 0L;
    }

    public Component getDescription() {
        return this.stack.getHoverName();
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        if (this.partitionList.isEmpty()) {
            return false;
        }
        return this.partitionList.matchesFilter(what, this.partitionListMode);
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public void fillOutput() {
        this.getCellItems();
        if (this.voidMode == VoidMode.TRASH || this.voidMode.getPower() == 0) {
            this.voidEnergy = 0.0;
            return;
        }
        AEItemKey output = AEItemKey.of((ItemLike)this.voidMode.output);
        long amt = (long)(this.voidEnergy / (double)this.voidMode.getPower());
        if (output != null && amt > 0L) {
            long cur = this.getCellItems().getLong((Object)output);
            this.getCellItems().put((Object)output, cur + amt);
        }
    }

    public Optional<TooltipComponent> getTooltipImage() {
        boolean hasMoreContent;
        List<Object> content;
        ArrayList<ItemStack> upgradeStacks = new ArrayList<ItemStack>();
        if (AEConfig.instance().isTooltipShowCellUpgrades()) {
            for (ItemStack upgrade : this.getUpgradesInventory()) {
                upgradeStacks.add(upgrade);
            }
        }
        if (AEConfig.instance().isTooltipShowCellContent()) {
            content = new ArrayList();
            int maxCountShown = AEConfig.instance().getTooltipMaxCellContentShown();
            KeyCounter availableStacks = this.getAvailableStacks();
            for (Object2LongMap.Entry entry : availableStacks) {
                content.add(new GenericStack((AEKey)entry.getKey(), entry.getLongValue()));
            }
            content.sort(Comparator.comparingLong(GenericStack::amount).reversed());
            boolean bl = hasMoreContent = content.size() > maxCountShown;
            if (content.size() > maxCountShown) {
                content.subList(maxCountShown, content.size()).clear();
            }
        } else {
            hasMoreContent = false;
            content = Collections.emptyList();
        }
        return Optional.of(new StorageCellTooltipComponent(upgradeStacks, content, hasMoreContent, true));
    }

    private static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.getItem() instanceof ItemVoidCell;
        }

        @Nullable
        public StorageCell getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new VoidCellInventory(is, host) : null;
        }
    }
}

