/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.utils;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeMultiset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.CompoundFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.DifferenceFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.IntersectionFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.ingredients.WrappedIngredient;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "JAOPCA Executor Thread"));
    private TagManager tagManager;
    private List<TagManager.LoadResult<?>> lastTagResults = List.of();
    private Map<ResourceKey<? extends Registry<?>>, SetMultimap<ResourceLocation, Object>> tagMap = new TreeMap();
    private static final Comparator<Fluid> FLOWING_FLUID_COMPARATOR = (fluid1, fluid2) -> {
        FlowingFluid fFluid;
        FlowingFluid fFluid2;
        boolean flag1 = fluid1 instanceof FlowingFluid && (fFluid2 = (FlowingFluid)fluid1) == fFluid2.getFlowing();
        boolean flag2 = fluid2 instanceof FlowingFluid && (fFluid = (FlowingFluid)fluid2) == fFluid.getFlowing();
        return Boolean.compare(flag1, flag2);
    };
    private static final Predicate<String> CONFIG_MATERIAL_PREDICATE = s -> s.equals("*") || s.startsWith("*") && MaterialType.fromName(s.substring(1)) != null || MaterialHandler.containsMaterial(s);
    private static final Predicate<String> CONFIG_MODULE_PREDICATE = s -> s.equals("*") || ModuleHandler.getModuleMap().containsKey(s);

    private MiscHelper() {
    }

    public void setTagManager(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    @Override
    public ResourceLocation createResourceLocation(String location, String defaultNamespace) {
        if (StringUtils.contains((CharSequence)location, (int)58)) {
            return ResourceLocation.parse((String)location);
        }
        return ResourceLocation.fromNamespaceAndPath((String)defaultNamespace, (String)location);
    }

    @Override
    public ResourceLocation createResourceLocation(String location) {
        return this.createResourceLocation(location, "c");
    }

    @Override
    public ResourceLocation getRecipeKey(String category, String material) {
        return this.createResourceLocation(category + "." + material, "jaopca");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material) {
        return this.getTagLocation(form, material, "/");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material, String separator) {
        return this.createResourceLocation(form + (String)(StringUtils.isEmpty((CharSequence)material) ? "" : (StringUtils.isEmpty((CharSequence)separator) ? "/" : separator) + material));
    }

    @Override
    public ItemStack getItemStack(Object obj, int count) {
        ItemStack ret = this.getPreferredItemStack((Iterable)this.getIngredientResolved(obj).getRight(), count);
        return ret.isEmpty() ? ItemStack.EMPTY : ret;
    }

    @Override
    public Ingredient getIngredient(Object obj) {
        return (Ingredient)this.getIngredientResolved(obj).getLeft();
    }

    @Override
    public SizedIngredient getSizedIngredient(Object obj, int count) {
        Ingredient ing = this.getIngredient(obj);
        return ing == null ? null : new SizedIngredient(ing, count);
    }

    /*
     * Unable to fully structure code
     */
    public Pair<Ingredient, Set<Item>> getIngredientResolved(Object obj) {
        ing = null;
        items = new LinkedHashSet<Item>();
        v0 = obj;
        Objects.requireNonNull(v0);
        var4_4 = v0;
        var5_6 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Supplier.class, CompoundIngredientObject.class, Ingredient.class, String.class, ResourceLocation.class, TagKey.class, ItemStack.class, ItemStack[].class, ItemLike.class, ItemLike[].class, Ingredient.Value.class, Ingredient.Value[].class, JsonElement.class}, (Object)var4_4, var5_6)) {
            case 0: {
                supplier = (Supplier)var4_4;
                pair = this.getIngredientResolved(supplier.get());
                ing = (Ingredient)pair.getLeft();
                items.addAll((Collection)pair.getRight());
                break;
            }
            case 1: {
                var7_9 = (CompoundIngredientObject)var4_4;
                type = var10_10 = var7_9.type();
                ingredients = var10_10 = var7_9.ingredients();
                ings = Arrays.stream(ingredients).map((Function<Object, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIngredientResolved(java.lang.Object ), (Ljava/lang/Object;)Lorg/apache/commons/lang3/tuple/Pair;)((MiscHelper)this)).toList();
                if (ings.size() != 1) ** GOTO lbl29
                pair = ings.get(0);
                ing = (Ingredient)pair.getLeft();
                items.addAll((Collection)pair.getRight());
                break;
lbl29:
                // 1 sources

                if (ings.size() <= 1) break;
                switch (1.$SwitchMap$thelm$jaopca$api$ingredients$CompoundIngredientObject$Type[type.ordinal()]) {
                    case 1: {
                        if (ings.stream().allMatch((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$1(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)())) break;
                        ing = CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$2(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)()).map((Function<Pair, Ingredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/minecraft/world/item/crafting/Ingredient;)()).toArray((IntFunction<Ingredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getIngredientResolved$3(int ), (I)[Lnet/minecraft/world/item/crafting/Ingredient;)())));
                        items.addAll(ings.stream().map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(new HashSet<E>(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIngredientResolved$4(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                        break;
                    }
                    case 2: {
                        if (ings.stream().anyMatch((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$5(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)())) break;
                        ing = IntersectionIngredient.of((Ingredient[])((Ingredient[])ings.stream().map((Function<Pair, Ingredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/minecraft/world/item/crafting/Ingredient;)()).toArray((IntFunction<Ingredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getIngredientResolved$6(int ), (I)[Lnet/minecraft/world/item/crafting/Ingredient;)())));
                        items.addAll(ings.stream().map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(Sets.newHashSet((Iterable)BuiltInRegistries.ITEM), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIngredientResolved$7(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                        break;
                    }
                    case 3: {
                        firstPair = ings.get(0);
                        if (((Set)firstPair.getRight()).isEmpty()) break;
                        ing = DifferenceIngredient.of((Ingredient)((Ingredient)firstPair.getLeft()), (Ingredient)CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().skip(1L).filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$8(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)()).map((Function<Pair, Ingredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/minecraft/world/item/crafting/Ingredient;)()).toArray((IntFunction<Ingredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getIngredientResolved$9(int ), (I)[Lnet/minecraft/world/item/crafting/Ingredient;)()))));
                        items.addAll((Collection)firstPair.getRight());
                        items.removeAll(ings.stream().skip(1L).map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(new HashSet<E>(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIngredientResolved$10(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                    }
                }
                break;
            }
            case 2: {
                ing = itemIng = (Ingredient)var4_4;
                BuiltInRegistries.ITEM.forEach((Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/item/Item;)V)(items));
                break;
            }
            case 3: {
                str = (String)var4_4;
                location = ResourceLocation.parse((String)str);
                ing = Ingredient.of(this.getItemTagKey(location));
                items.addAll(this.getItemTagValues(location));
                break;
            }
            case 4: {
                location = (ResourceLocation)var4_4;
                ing = Ingredient.of(this.getItemTagKey(location));
                items.addAll(this.getItemTagValues(location));
                break;
            }
            case 5: {
                key = (TagKey)var4_4;
                ing = Ingredient.of(this.getItemTagKey(key.location()));
                items.addAll(this.getItemTagValues(key.location()));
                break;
            }
            case 6: {
                stack = (ItemStack)var4_4;
                if (stack.isEmpty()) break;
                ing = Ingredient.of((ItemStack[])new ItemStack[]{stack});
                items.add(stack.getItem());
                break;
            }
            case 7: {
                stacks = (ItemStack[])var4_4;
                nonEmpty = Arrays.stream(stacks).filter((Predicate<ItemStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$11(net.minecraft.world.item.ItemStack ), (Lnet/minecraft/world/item/ItemStack;)Z)()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = Ingredient.of(nonEmpty.stream());
                nonEmpty.stream().map((Function<ItemStack, Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getItem(), (Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/Item;)()).forEach((Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/item/Item;)V)(items));
                break;
            }
            case 8: {
                item = (ItemLike)var4_4;
                if (item.asItem() == Items.AIR) break;
                ing = Ingredient.of((ItemLike[])new ItemLike[]{item});
                items.add(item.asItem());
                break;
            }
            case 9: {
                itemz = (ItemLike[])var4_4;
                nonEmpty = Arrays.stream(itemz).map((Function<ItemLike, Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, asItem(), (Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/item/Item;)()).filter((Predicate<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getIngredientResolved$12(net.minecraft.world.item.Item ), (Lnet/minecraft/world/item/Item;)Z)()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = Ingredient.of((ItemLike[])((ItemLike[])nonEmpty.toArray((IntFunction<Item[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getIngredientResolved$13(int ), (I)[Lnet/minecraft/world/item/Item;)())));
                items.addAll(nonEmpty);
                break;
            }
            case 10: {
                value = (Ingredient.Value)var4_4;
                ing = Ingredient.fromValues(Stream.of(value));
                BuiltInRegistries.ITEM.forEach((Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/item/Item;)V)(items));
                break;
            }
            case 11: {
                values = (Ingredient.Value[])var4_4;
                ing = Ingredient.fromValues(Stream.of(values));
                BuiltInRegistries.ITEM.forEach((Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/item/Item;)V)(items));
                break;
            }
            case 12: {
                json = (JsonElement)var4_4;
                ing = Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.String ), (Ljava/lang/String;)V)((Logger)MiscHelper.LOGGER)).orElse(null);
                BuiltInRegistries.ITEM.forEach((Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/item/Item;)V)(items));
                break;
            }
        }
        items.remove(Items.AIR);
        return Pair.of((Object)(items.isEmpty() != false ? null : ing), items);
        catch (Throwable var4_5) {
            throw new MatchException(var4_5.toString(), var4_5);
        }
    }

    @Override
    public TagKey<Item> getItemTagKey(ResourceLocation location) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }

    @Override
    public Collection<Item> getItemTagValues(ResourceLocation location) {
        return this.getTagValues(Registries.ITEM, location);
    }

    @Override
    public ItemStack getPreferredItemStack(Iterable<Item> iterable, int count) {
        return new ItemStack((ItemLike)this.getPreferredEntry(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0), iterable).orElse(Items.AIR), count);
    }

    @Override
    public FluidStack getFluidStack(Object obj, int amount) {
        FluidStack ret = this.getPreferredFluidStack((Iterable)this.getFluidIngredientResolved(obj).getRight(), amount);
        return ret.isEmpty() ? FluidStack.EMPTY : ret;
    }

    @Override
    public FluidIngredient getFluidIngredient(Object obj) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj).getLeft();
    }

    @Override
    public SizedFluidIngredient getSizedFluidIngredient(Object obj, int amount) {
        FluidIngredient ing = this.getFluidIngredient(obj);
        return ing == null ? null : new SizedFluidIngredient(ing, amount);
    }

    /*
     * Unable to fully structure code
     */
    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj) {
        ing = null;
        fluids = new HashSet<Fluid>();
        v0 = obj;
        Objects.requireNonNull(v0);
        var4_4 = v0;
        var5_6 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Supplier.class, CompoundIngredientObject.class, FluidIngredient.class, String.class, ResourceLocation.class, TagKey.class, FluidStack.class, FluidStack[].class, Fluid.class, Fluid[].class, IFluidLike.class, IFluidLike[].class, JsonElement.class}, (Object)var4_4, var5_6)) {
            case 0: {
                supplier = (Supplier)var4_4;
                pair = this.getFluidIngredientResolved(((Supplier)obj).get());
                ing = (FluidIngredient)pair.getLeft();
                fluids.addAll((Collection)pair.getRight());
                break;
            }
            case 1: {
                var7_9 = (CompoundIngredientObject)var4_4;
                type = var10_10 = var7_9.type();
                ingredients = var10_10 = var7_9.ingredients();
                ings = Arrays.stream(ingredients).map((Function<Object, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFluidIngredientResolved(java.lang.Object ), (Ljava/lang/Object;)Lorg/apache/commons/lang3/tuple/Pair;)((MiscHelper)this)).toList();
                if (ings.size() != 1) ** GOTO lbl29
                pair = ings.get(0);
                ing = (FluidIngredient)pair.getLeft();
                fluids.addAll((Collection)pair.getRight());
                break;
lbl29:
                // 1 sources

                if (ings.size() <= 1) break;
                switch (1.$SwitchMap$thelm$jaopca$api$ingredients$CompoundIngredientObject$Type[type.ordinal()]) {
                    case 1: {
                        if (ings.stream().allMatch((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$14(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)())) break;
                        ing = CompoundFluidIngredient.of((FluidIngredient[])((FluidIngredient[])ings.stream().filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$15(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)()).map((Function<Pair, FluidIngredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)()).toArray((IntFunction<FluidIngredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$16(int ), (I)[Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)())));
                        fluids.addAll(ings.stream().map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(new HashSet<E>(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFluidIngredientResolved$17(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                        break;
                    }
                    case 2: {
                        if (ings.stream().anyMatch((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$18(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)())) break;
                        ing = IntersectionFluidIngredient.of((FluidIngredient[])((FluidIngredient[])ings.stream().map((Function<Pair, FluidIngredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)()).toArray((IntFunction<FluidIngredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$19(int ), (I)[Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)())));
                        fluids.addAll(ings.stream().map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(Sets.newHashSet((Iterable)BuiltInRegistries.FLUID), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFluidIngredientResolved$20(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                        break;
                    }
                    case 3: {
                        firstPair = ings.get(0);
                        if (((Set)firstPair.getRight()).isEmpty()) break;
                        ing = DifferenceFluidIngredient.of((FluidIngredient)((FluidIngredient)firstPair.getLeft()), (FluidIngredient)CompoundFluidIngredient.of((FluidIngredient[])((FluidIngredient[])ings.stream().skip(1L).filter((Predicate<Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$21(org.apache.commons.lang3.tuple.Pair ), (Lorg/apache/commons/lang3/tuple/Pair;)Z)()).map((Function<Pair, FluidIngredient>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lorg/apache/commons/lang3/tuple/Pair;)Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)()).toArray((IntFunction<FluidIngredient[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$22(int ), (I)[Lnet/neoforged/neoforge/fluids/crafting/FluidIngredient;)()))));
                        fluids.addAll((Collection)firstPair.getRight());
                        fluids.removeAll(ings.stream().skip(1L).map((Function<Pair, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRight(), (Lorg/apache/commons/lang3/tuple/Pair;)Ljava/util/Set;)()).reduce(new HashSet<E>(), (BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFluidIngredientResolved$23(java.util.Set java.util.Set ), (Ljava/util/Set;Ljava/util/Set;)Ljava/util/Set;)()));
                    }
                }
                break;
            }
            case 2: {
                ing = fluidIng = (FluidIngredient)var4_4;
                BuiltInRegistries.FLUID.forEach((Consumer<Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/level/material/Fluid;)V)(fluids));
                break;
            }
            case 3: {
                str = (String)var4_4;
                location = ResourceLocation.parse((String)str);
                ing = FluidIngredient.tag(this.getFluidTagKey(location));
                fluids.addAll(this.getFluidTagValues(location));
                break;
            }
            case 4: {
                location = (ResourceLocation)var4_4;
                ing = FluidIngredient.tag(this.getFluidTagKey(location));
                fluids.addAll(this.getFluidTagValues(location));
                break;
            }
            case 5: {
                key = (TagKey)var4_4;
                ing = FluidIngredient.tag(this.getFluidTagKey(key.location()));
                fluids.addAll(this.getFluidTagValues(key.location()));
                break;
            }
            case 6: {
                stack = (FluidStack)var4_4;
                if (stack.isEmpty()) break;
                ing = FluidIngredient.of((FluidStack[])new FluidStack[]{stack});
                fluids.add(stack.getFluid());
                break;
            }
            case 7: {
                stacks = (FluidStack[])var4_4;
                nonEmpty = Arrays.stream(stacks).filter((Predicate<FluidStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$24(net.neoforged.neoforge.fluids.FluidStack ), (Lnet/neoforged/neoforge/fluids/FluidStack;)Z)()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = FluidIngredient.of((FluidStack[])((FluidStack[])nonEmpty.toArray((IntFunction<FluidStack[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$25(int ), (I)[Lnet/neoforged/neoforge/fluids/FluidStack;)())));
                nonEmpty.stream().map((Function<FluidStack, Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFluid(), (Lnet/neoforged/neoforge/fluids/FluidStack;)Lnet/minecraft/world/level/material/Fluid;)()).forEach((Consumer<Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/level/material/Fluid;)V)(fluids));
                break;
            }
            case 8: {
                fluid = (Fluid)var4_4;
                if (fluid == Fluids.EMPTY) break;
                ing = FluidIngredient.of((Fluid[])new Fluid[]{fluid});
                fluids.add(fluid);
                break;
            }
            case 9: {
                fluidz = (Fluid[])var4_4;
                nonEmpty = Arrays.stream(fluidz).filter((Predicate<Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$26(net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Z)()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = FluidIngredient.of((Fluid[])((Fluid[])nonEmpty.toArray((IntFunction<Fluid[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$27(int ), (I)[Lnet/minecraft/world/level/material/Fluid;)())));
                fluids.addAll(nonEmpty);
                break;
            }
            case 10: {
                fluid = (IFluidLike)var4_4;
                if (fluid.asFluid() == Fluids.EMPTY) break;
                ing = FluidIngredient.of((Fluid[])new Fluid[]{fluid.asFluid()});
                fluids.add(fluid.asFluid());
                break;
            }
            case 11: {
                fluidz = (IFluidLike[])var4_4;
                nonEmpty = Arrays.stream(fluidz).map((Function<IFluidLike, Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, asFluid(), (Lthelm/jaopca/api/fluids/IFluidLike;)Lnet/minecraft/world/level/material/Fluid;)()).filter((Predicate<Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFluidIngredientResolved$28(net.minecraft.world.level.material.Fluid ), (Lnet/minecraft/world/level/material/Fluid;)Z)()).toList();
                if (nonEmpty.isEmpty()) break;
                ing = FluidIngredient.of((Fluid[])((Fluid[])nonEmpty.toArray((IntFunction<Fluid[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getFluidIngredientResolved$29(int ), (I)[Lnet/minecraft/world/level/material/Fluid;)())));
                fluids.addAll(nonEmpty);
                break;
            }
            case 12: {
                json = (JsonElement)var4_4;
                ing = FluidIngredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.String ), (Ljava/lang/String;)V)((Logger)MiscHelper.LOGGER)).orElse(null);
                BuiltInRegistries.FLUID.forEach((Consumer<Fluid>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lnet/minecraft/world/level/material/Fluid;)V)(fluids));
                break;
            }
        }
        fluids.remove(Fluids.EMPTY);
        return Pair.of((Object)(fluids.isEmpty() != false ? null : ing), fluids);
        catch (Throwable var4_5) {
            throw new MatchException(var4_5.toString(), var4_5);
        }
    }

    @Override
    public TagKey<Fluid> getFluidTagKey(ResourceLocation location) {
        return TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)location);
    }

    @Override
    public Collection<Fluid> getFluidTagValues(ResourceLocation location) {
        return this.getTagValues(Registries.FLUID, location);
    }

    @Override
    public FluidStack getPreferredFluidStack(Iterable<Fluid> iterable, int amount) {
        return new FluidStack(this.getPreferredEntry(this.flowingFluidComparator(), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).getKey(arg_0), iterable).orElse(Fluids.EMPTY), amount);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceKey<? extends Registry<T>> registry, ResourceLocation location) {
        if (this.tagManager == null) {
            throw new IllegalStateException("Tag manager not initialized.");
        }
        if (this.tagManager.getResult() != this.lastTagResults) {
            this.lastTagResults = this.tagManager.getResult();
            this.tagMap.clear();
            if (this.lastTagResults.isEmpty()) {
                throw new IllegalStateException("Tags have not been loaded yet.");
            }
            this.lastTagResults.forEach(result -> {
                SetMultimap map = this.tagMap.computeIfAbsent(result.key(), k -> MultimapBuilder.treeKeys().linkedHashSetValues().build());
                result.tags().forEach((loc, tag) -> tag.forEach(holder -> map.put(loc, holder.value())));
            });
        }
        return Collections2.transform((Collection)this.tagMap.getOrDefault(registry, (SetMultimap<ResourceLocation, Object>)ImmutableSetMultimap.of()).asMap().getOrDefault(location, Set.of()), o -> o);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceLocation registry, ResourceLocation location) {
        return this.getTagValues(ResourceKey.createRegistryKey((ResourceLocation)registry), location);
    }

    @Override
    public <T> Optional<T> getPreferredEntry(Function<T, ResourceLocation> keyGetter, Iterable<T> iterable) {
        return Streams.stream(iterable).min(this.entryPreferenceComparator(keyGetter));
    }

    @Override
    public <T> Optional<T> getPreferredEntry(Comparator<T> comparator, Function<T, ResourceLocation> keyGetter, Iterable<T> iterable) {
        return Streams.stream(iterable).min(comparator.thenComparing(this.entryPreferenceComparator(keyGetter)));
    }

    @Override
    public <T> Comparator<T> entryPreferenceComparator(Function<T, ResourceLocation> keyGetter) {
        return (entry1, entry2) -> {
            int index2;
            ResourceLocation key2;
            ResourceLocation key1 = (ResourceLocation)keyGetter.apply(entry1);
            if (key1 == (key2 = (ResourceLocation)keyGetter.apply(entry2))) {
                return 0;
            }
            if (key1 == null) {
                return 1;
            }
            if (key2 == null) {
                return -1;
            }
            int index1 = ConfigHandler.PREFERRED_MODS.indexOf(key1.getNamespace());
            if (index1 == (index2 = ConfigHandler.PREFERRED_MODS.indexOf(key2.getNamespace()))) {
                return 0;
            }
            if (index1 == -1) {
                return 1;
            }
            if (index2 == -1) {
                return -1;
            }
            return Integer.compare(index1, index2);
        };
    }

    @Override
    public Comparator<Fluid> flowingFluidComparator() {
        return FLOWING_FLUID_COMPARATOR;
    }

    @Override
    public void caclulateMaterialSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = configList.stream().map(s -> s.startsWith("*") ? s.toLowerCase(Locale.US) : s).collect(Collectors.toCollection(TreeMultiset::create));
        int listCount = list.count((Object)"*");
        MaterialHandler.getMaterials().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        for (MaterialType type : MaterialType.values()) {
            int listCount1 = list.count((Object)("*" + type.getName()));
            MaterialHandler.getMaterials().stream().filter(m -> m.getType() == type).forEach(m -> list.add((Object)m.getName(), listCount1));
            list.remove((Object)("*" + type.getName()), listCount1);
        }
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public void caclulateModuleSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        ModuleHandler.getModules().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public Ingredient wrapIngredient(Ingredient ing) {
        return WrappedIngredient.of(ing);
    }

    @Override
    public JsonElement serializeIngredient(Ingredient ing) {
        return this.serialize(Ingredient.CODEC, ing);
    }

    @Override
    public JsonObject serializeItemStack(ItemStack stack) {
        return this.serialize(ItemStack.CODEC, stack).getAsJsonObject();
    }

    @Override
    public JsonObject serializeFluidStack(FluidStack stack) {
        return this.serialize(FluidStack.CODEC, stack).getAsJsonObject();
    }

    @Override
    public JsonElement serializeRecipe(Recipe<?> recipe) {
        return this.serialize(Recipe.CODEC, recipe);
    }

    @Override
    public <T> JsonElement serialize(Codec<T> codec, T obj) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, obj).resultOrPartial(arg_0 -> ((Logger)LOGGER).warn(arg_0)).get();
    }

    @Override
    public Predicate<String> configMaterialPredicate() {
        return CONFIG_MATERIAL_PREDICATE;
    }

    @Override
    public Predicate<String> configModulePredicate() {
        return CONFIG_MODULE_PREDICATE;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    @Override
    public boolean hasResource(ResourceLocation location) {
        return (Boolean)this.conditionalSupplier(() -> ((Dist)FMLEnvironment.dist).isClient(), () -> () -> Minecraft.getInstance().getResourceManager().getResource(location).isPresent(), () -> () -> false).get();
    }

    public <T> Future<T> submitAsyncTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submitAsyncTask(Runnable task) {
        return this.executor.submit(task);
    }

    public int squareColorDifference(int color1, int color2) {
        int diffR = (color1 << 16 & 0xFF) - (color2 << 16 & 0xFF);
        int diffG = (color1 << 8 & 0xFF) - (color2 << 8 & 0xFF);
        int diffB = (color1 & 0xFF) - (color2 & 0xFF);
        return diffR * diffR + diffG * diffG + diffB * diffB;
    }

    public Predicate<String> modVersionNotLoaded(Logger logger) {
        return dep -> {
            VersionRange versionRange;
            ModList modList = ModList.get();
            int separatorIndex = dep.lastIndexOf(64);
            String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
            String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1);
            try {
                versionRange = VersionRange.createFromVersionSpec((String)spec);
            }
            catch (InvalidVersionSpecificationException e) {
                logger.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
                return true;
            }
            if (modList.isLoaded(modId)) {
                ArtifactVersion version = ((ModContainer)modList.getModContainerById(modId).get()).getModInfo().getVersion();
                if (versionRange.containsVersion(version)) {
                    return false;
                }
                logger.warn("Mod {} in version range {} was requested, was {}", (Object)modId, (Object)versionRange, (Object)version);
                return true;
            }
            return true;
        };
    }

    public boolean classNotExists(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private static /* synthetic */ Fluid[] lambda$getFluidIngredientResolved$29(int x$0) {
        return new Fluid[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$28(Fluid f) {
        return f != Fluids.EMPTY;
    }

    private static /* synthetic */ Fluid[] lambda$getFluidIngredientResolved$27(int x$0) {
        return new Fluid[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$26(Fluid f) {
        return f != Fluids.EMPTY;
    }

    private static /* synthetic */ FluidStack[] lambda$getFluidIngredientResolved$25(int x$0) {
        return new FluidStack[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$24(FluidStack s) {
        return !s.isEmpty();
    }

    private static /* synthetic */ Set lambda$getFluidIngredientResolved$23(Set s1, Set s2) {
        s1.addAll(s2);
        return s1;
    }

    private static /* synthetic */ FluidIngredient[] lambda$getFluidIngredientResolved$22(int x$0) {
        return new FluidIngredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$21(Pair p) {
        return !((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ Set lambda$getFluidIngredientResolved$20(Set s1, Set s2) {
        s1.retainAll(s2);
        return s1;
    }

    private static /* synthetic */ FluidIngredient[] lambda$getFluidIngredientResolved$19(int x$0) {
        return new FluidIngredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$18(Pair p) {
        return ((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ Set lambda$getFluidIngredientResolved$17(Set s1, Set s2) {
        s1.addAll(s2);
        return s1;
    }

    private static /* synthetic */ FluidIngredient[] lambda$getFluidIngredientResolved$16(int x$0) {
        return new FluidIngredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$15(Pair p) {
        return !((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ boolean lambda$getFluidIngredientResolved$14(Pair p) {
        return ((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ Item[] lambda$getIngredientResolved$13(int x$0) {
        return new Item[x$0];
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$12(Item i) {
        return i != Items.AIR;
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$11(ItemStack s) {
        return !s.isEmpty();
    }

    private static /* synthetic */ Set lambda$getIngredientResolved$10(Set s1, Set s2) {
        s1.addAll(s2);
        return s1;
    }

    private static /* synthetic */ Ingredient[] lambda$getIngredientResolved$9(int x$0) {
        return new Ingredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$8(Pair p) {
        return !((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ Set lambda$getIngredientResolved$7(Set s1, Set s2) {
        s1.retainAll(s2);
        return s1;
    }

    private static /* synthetic */ Ingredient[] lambda$getIngredientResolved$6(int x$0) {
        return new Ingredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$5(Pair p) {
        return ((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ Set lambda$getIngredientResolved$4(Set s1, Set s2) {
        s1.addAll(s2);
        return s1;
    }

    private static /* synthetic */ Ingredient[] lambda$getIngredientResolved$3(int x$0) {
        return new Ingredient[x$0];
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$2(Pair p) {
        return !((Set)p.getRight()).isEmpty();
    }

    private static /* synthetic */ boolean lambda$getIngredientResolved$1(Pair p) {
        return ((Set)p.getRight()).isEmpty();
    }
}

