/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class ShapelessRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final CraftingBookCategory category;
    public final Object output;
    public final int count;
    public final Object[] input;

    public ShapelessRecipeSerializer(ResourceLocation key, Object output, int count, Object ... input) {
        this(key, "", CraftingBookCategory.MISC, output, count, input);
    }

    public ShapelessRecipeSerializer(ResourceLocation key, String group, Object output, int count, Object ... input) {
        this(key, group, CraftingBookCategory.MISC, output, count, input);
    }

    public ShapelessRecipeSerializer(ResourceLocation key, CraftingBookCategory category, Object output, int count, Object ... input) {
        this(key, "", category, output, count, input);
    }

    public ShapelessRecipeSerializer(ResourceLocation key, String group, CraftingBookCategory category, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.category = Objects.requireNonNull(category);
        this.output = output;
        this.count = count;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public JsonElement get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        NonNullList ingredients = NonNullList.create();
        for (Object in : this.input) {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            ingredients.add((Object)ing);
        }
        ShapelessRecipe recipe = new ShapelessRecipe(this.group, this.category, stack, ingredients);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

